/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.UI.CfmlLookUpItemUtil;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlComponentType;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlParameter;
import com.intellij.coldFusion.model.psi.CfmlParametersList;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.impl.CfmlFunctionParameterImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlFunctionImpl
extends CfmlCompositeElement
implements CfmlFunction,
PsiNameIdentifierOwner {
    public CfmlFunctionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "<init>"));
        }
        super(node);
    }

    public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "setName"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        CfmlReferenceExpression newElement = CfmlPsiUtil.createReferenceExpression(name, this.getProject());
        this.getNode().replaceChild(this.getReferenceElement().getNode(), newElement.getNode());
        return this;
    }

    @Nullable
    public PsiElement getReferenceElement() {
        return this.findChildByType(CfscriptTokenTypes.IDENTIFIER);
    }

    @NotNull
    public String getFunctionName() {
        PsiElement element = this.getReferenceElement();
        String string = element != null ? element.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getFunctionName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getFunctionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element = this.getReferenceElement();
        Object object = element != null ? element : this;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getNavigationElement"));
        }
        return object;
    }

    @Override
    @NotNull
    public String getParametersAsString() {
        String string = this.getFunctionInfo().getParametersListPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getParametersAsString"));
        }
        return string;
    }

    @Override
    @NotNull
    public CfmlParameter[] getParameters() {
        CfmlParametersList parametersList = (CfmlParametersList)this.findChildByClass(CfmlParametersList.class);
        if (parametersList != null) {
            CfmlParameter[] cfmlParameterArray = parametersList.getParameters();
            if (cfmlParameterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getParameters"));
            }
            return cfmlParameterArray;
        }
        if (CfmlFunctionParameterImpl.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getParameters"));
        }
        return CfmlFunctionParameterImpl.EMPTY_ARRAY;
    }

    @Nullable
    public CfmlParametersList getParametersList() {
        return (CfmlParametersList)this.findChildByClass(CfmlParametersList.class);
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        PsiElement type = this.findChildByType(CfmlElementTypes.TYPE);
        return type != null ? new CfmlComponentType(type.getText(), this.getContainingFile(), this.getProject()) : null;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.METHOD_ICON;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "processDeclarations"));
        }
        processor.execute((PsiElement)this, state);
        CfmlParametersList params = (CfmlParametersList)this.findChildByClass(CfmlParametersList.class);
        return params == null || params.processDeclarations(processor, state, null, params);
    }

    public PsiElement getNameIdentifier() {
        return this.getReferenceElement();
    }

    public int getTextOffset() {
        PsiElement element = this.getNavigationElement();
        return element.getTextRange().getStartOffset();
    }

    public boolean isTrulyDeclaration() {
        return true;
    }

    @Override
    @NotNull
    public CfmlFunctionDescription getFunctionInfo() {
        CfmlFunctionDescription cfmlFunctionDescription = CfmlLookUpItemUtil.getFunctionDescription(this);
        if (cfmlFunctionDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "getFunctionInfo"));
        }
        return cfmlFunctionDescription;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/coldFusion/model/psi/impl/CfmlFunctionImpl", "accept"));
        }
        if (visitor instanceof CfmlRecursiveElementVisitor) {
            ((CfmlRecursiveElementVisitor)visitor).visitCfmlFunction(this);
        } else {
            super.accept(visitor);
        }
    }
}

