/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlAttribute;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public class CfmlAttributeImpl
extends CfmlCompositeElement
implements CfmlAttribute {
    public CfmlAttributeImpl(ASTNode astNode) {
        super(astNode);
    }

    public String getName() {
        return this.getAttributeName();
    }

    @Nullable
    public PsiElement getValueElement() {
        return this.findChildByType(CfmlElementTypes.ATTRIBUTE_VALUE);
    }

    @Override
    public String getAttributeName() {
        PsiElement id = this.findChildByType(CfmlTokenTypes.ATTRIBUTE);
        if (id == null) {
            id = this.findChildByType(CfscriptTokenTypes.IDENTIFIER);
        }
        if (id != null) {
            return id.getText().toLowerCase();
        }
        return "";
    }

    @Override
    @Nullable
    public String getPureAttributeValue() {
        PsiElement element = this.getValueElement();
        if (element != null) {
            PsiElement[] children = element.getChildren();
            if (children.length > 1) {
                return "";
            }
            return element.getText();
        }
        return "";
    }
}

