/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlComponentConstructorCall;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlFileReferenceSet;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.CfmlJavaLoaderClassType;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlStringLiteralExpression
extends CfmlCompositeElement
implements CfmlExpression {
    public CfmlStringLiteralExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        return CfmlPsiUtil.getTypeByName("java.lang.String", this.getProject());
    }

    @Nullable
    public PsiElement getValueElement() {
        return this.findChildByType(CfmlTokenTypes.STRING_TEXT);
    }

    @NotNull
    public String getValue() {
        ASTNode value = this.getNode().findChildByType(CfmlTokenTypes.STRING_TEXT);
        if (value != null) {
            String string = value.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getValue"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getValue"));
        }
        return "";
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiElement stringTextElement;
        CfmlFunctionCallExpression functionCallEl = (CfmlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this, CfmlFunctionCallExpression.class);
        if (functionCallEl != null && functionCallEl.isCreateObject()) {
            ASTNode referenceNode;
            String[] args = functionCallEl.getArgumentsAsStrings();
            CfmlExpression[] expressions = functionCallEl.getArguments();
            PsiElement referenceElement = this.findChildByType(CfmlTokenTypes.STRING_TEXT);
            if (referenceElement == null) {
                PsiReference[] psiReferenceArray = super.getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                }
                return psiReferenceArray;
            }
            if (args.length == 2 && "java".equals(args[0]) && expressions.length == 2 && expressions[1] == this) {
                JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
                PsiReference[] psiReferenceArray = provider.getReferencesByString(args[1], referenceElement, 0);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                }
                return psiReferenceArray;
            }
            if ((args.length == 2 && "component".equals(args[0]) && expressions.length == 2 && expressions[1] == this || args.length == 1 && expressions.length == 1 && expressions[0] == this) && (referenceNode = referenceElement.getNode()) != null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new CfmlComponentReference(referenceNode)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                }
                return psiReferenceArray;
            }
        } else if (functionCallEl != null && functionCallEl.isExpandPath()) {
            PsiElement referenceElement = this.findChildByType(CfmlTokenTypes.STRING_TEXT);
            if (referenceElement == null) {
                PsiReference[] psiReferenceArray = super.getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                }
                return psiReferenceArray;
            }
            ASTNode referenceNode = referenceElement.getNode();
            if (referenceNode != null) {
                FileReference[] fileReferenceArray = new CfmlFileReferenceSet(this, 1).getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                }
                return fileReferenceArray;
            }
        } else if (functionCallEl != null && functionCallEl.isCreateFromJavaLoader()) {
            PsiElement stringTextElement2;
            CfmlExpression[] expressions = functionCallEl.getArguments();
            if (expressions.length > 0 && expressions[0] == this && (stringTextElement2 = this.findChildByType(CfmlTokenTypes.STRING_TEXT)) != null) {
                PsiElement secondChild = functionCallEl.getFirstChild().getFirstChild();
                if (!(secondChild instanceof CfmlReferenceExpression)) {
                    PsiReference[] psiReferenceArray = super.getReferences();
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                    }
                    return psiReferenceArray;
                }
                PsiType type = ((CfmlReferenceExpression)secondChild).getPsiType();
                if (!(type instanceof CfmlJavaLoaderClassType)) {
                    PsiReference[] psiReferenceArray = super.getReferences();
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                    }
                    return psiReferenceArray;
                }
                final GlobalSearchScope ss = ((CfmlJavaLoaderClassType)type).getSearchScope();
                String possibleJavaClassName = stringTextElement2.getText();
                JavaClassReferenceProvider provider = new JavaClassReferenceProvider(){

                    public GlobalSearchScope getScope(Project project) {
                        return ss;
                    }
                };
                PsiReference[] psiReferenceArray = provider.getReferencesByString(possibleJavaClassName, stringTextElement2, 0);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
                }
                return psiReferenceArray;
            }
        } else if ((this.getParent() instanceof CfmlComponentConstructorCall || this.getParent() instanceof CfmlImport) && (stringTextElement = this.findChildByType(CfmlTokenTypes.STRING_TEXT)) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new CfmlComponentReference(stringTextElement.getNode(), this)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlStringLiteralExpression", "getReferences"));
        }
        return psiReferenceArray;
    }
}

