/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CfmlComponentType
extends CfmlType {
    private final String myComponentQualifiedPath;
    private final Project myProject;
    private final CfmlFile myContainingFile;

    public CfmlComponentType(@NotNull String componentQualifiedPath, CfmlFile containingFile, Project project) {
        if (componentQualifiedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentQualifiedPath", "com/intellij/coldFusion/model/psi/CfmlComponentType", "<init>"));
        }
        super(componentQualifiedPath);
        this.myComponentQualifiedPath = componentQualifiedPath;
        this.myProject = project;
        this.myContainingFile = containingFile;
    }

    public Collection<CfmlComponent> resolve() {
        return CfmlComponentReference.resolveFromQualifiedName(this.myComponentQualifiedPath, this.myContainingFile);
    }

    @Override
    public boolean isValid() {
        return !this.resolve().isEmpty();
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return GlobalSearchScope.projectScope((Project)this.myProject);
    }
}

