/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.lexer;

import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptLexer;
import com.intellij.coldFusion.model.lexer._CfmlLexer;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class CfmlLexer
extends MergingLexerAdapter {
    private static final int LEXER_STATE_LIMIT = 65535;
    private Lexer myCfscriptLexer = null;
    private int myStartPosition = 0;
    private Project myProject;
    private final _CfmlLexer.CfmlLexerConfiguration myConfiguration;
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{CfmlTokenTypes.COMMENT, CfmlTokenTypes.WHITE_SPACE, CfmlTokenTypes.SCRIPT_EXPRESSION, CfmlElementTypes.TEMPLATE_TEXT});

    public CfmlLexer(boolean highlightingMode, Project project) {
        super((Lexer)new FlexAdapter((FlexLexer)new _CfmlLexer(project)), TOKENS_TO_MERGE);
        this.myProject = project;
        this.myConfiguration = ((_CfmlLexer)((FlexAdapter)this.getDelegate()).getFlex()).myCurrentConfiguration;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/coldFusion/model/lexer/CfmlLexer", "start"));
        }
        this.myCfscriptLexer = null;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    public int getState() {
        if (this.myCfscriptLexer != null) {
            int modifiedState = (this.myCfscriptLexer.getState() << 16) + 65535;
            assert (modifiedState != 0);
            return modifiedState;
        }
        int state = this.doGetState();
        assert (state >= 0 && state < 65535);
        return state;
    }

    private int doGetState() {
        return super.getState() + this.myConfiguration.getExtraState();
    }

    public void advance() {
        if (this.myCfscriptLexer != null) {
            this.myCfscriptLexer.advance();
            if (this.myCfscriptLexer.getTokenType() == null) {
                this.myCfscriptLexer = null;
            }
        } else {
            super.advance();
        }
    }

    public IElementType getTokenType() {
        if (this.myCfscriptLexer != null) {
            return this.myCfscriptLexer.getTokenType();
        }
        if (super.getTokenType() == CfmlElementTypes.CF_SCRIPT || super.getTokenType() == CfmlTokenTypes.SCRIPT_EXPRESSION) {
            int startPosition;
            this.myStartPosition = startPosition = super.getTokenStart();
            int endPosition = super.getTokenEnd();
            while (super.getTokenType() == CfmlTokenTypes.SCRIPT_EXPRESSION || super.getTokenType() == CfmlElementTypes.CF_SCRIPT) {
                endPosition = super.getTokenEnd();
                super.advance();
            }
            this.myCfscriptLexer = new CfscriptLexer(this.myProject);
            this.myCfscriptLexer.start(super.getBufferSequence().subSequence(startPosition, endPosition), 0, endPosition - startPosition, this.myCfscriptLexer.getState());
            return this.myCfscriptLexer.getTokenType();
        }
        return super.getTokenType();
    }

    public int getTokenStart() {
        if (this.myCfscriptLexer != null) {
            return this.myCfscriptLexer.getTokenStart() + this.myStartPosition;
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myCfscriptLexer != null) {
            return this.myCfscriptLexer.getTokenEnd() + this.myStartPosition;
        }
        return super.getTokenEnd();
    }
}

