/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.formatter;

import com.intellij.coldFusion.model.formatter.CfmlCodeStyleSettings;
import com.intellij.coldFusion.model.formatter.CfmlFormatterUtil;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;

public class CfmlSpacingProcessor
extends CfmlFormatterUtil {
    private final CommonCodeStyleSettings mySettings;
    private final CfmlCodeStyleSettings myCfmlSettings;
    private final ASTNode myNode;

    public CfmlSpacingProcessor(ASTNode node, CommonCodeStyleSettings settings, CfmlCodeStyleSettings cfmlSettings) {
        this.mySettings = settings;
        this.myCfmlSettings = cfmlSettings;
        this.myNode = node;
    }

    private static Spacing getSpacesInsideAttribute(IElementType type1, IElementType type2) {
        if (type1 == CfmlTokenTypes.ASSIGN || type2 == CfmlTokenTypes.ASSIGN) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)1);
        }
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)false, (int)1);
    }

    public Spacing getSpacing(Block child1, Block child2) {
        if (!(child1 instanceof AbstractBlock) || !(child2 instanceof AbstractBlock)) {
            return null;
        }
        IElementType elementType = this.myNode.getElementType();
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        IElementType type1 = node1.getElementType();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type2 = node2.getElementType();
        if (type2 == CfmlElementTypes.TAG || type2 == CfmlElementTypes.FORTAGEXPRESSION || type2 == CfmlElementTypes.ARGUMENT_TAG || type2 == CfmlElementTypes.FUNCTION_DEFINITION || type2 == CfmlElementTypes.SCRIPT_TAG) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)1);
        }
        if (type1 == CfmlTokenTypes.OPENER || type2 == CfmlTokenTypes.R_ANGLEBRACKET || type2 == CfmlTokenTypes.CLOSER) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (elementType == CfmlElementTypes.ATTRIBUTE) {
            return CfmlSpacingProcessor.getSpacesInsideAttribute(type1, type2);
        }
        if (type1 == CfmlTokenTypes.CF_TAG_NAME && node1.getTreePrev().getElementType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (type1 == CfmlTokenTypes.CF_TAG_NAME && type2 == CfmlElementTypes.ASSIGNMENT) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (type2 == CfmlElementTypes.ARGUMENT_LIST) {
            if (elementType == CfmlElementTypes.FUNCTION_CALL_EXPRESSION && type1 == CfmlElementTypes.REFERENCE_EXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
            }
        } else if (type2 == CfscriptTokenTypes.L_BRACKET) {
            if (elementType == CfmlElementTypes.IFEXPRESSION && type1 == CfscriptTokenTypes.IF_KEYWORD) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.WHILEEXPRESSION && type1 == CfscriptTokenTypes.WHILE_KEYWORD) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.FOREXPRESSION && type1 == CfscriptTokenTypes.FOR_KEYWORD) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.SWITCHEXPRESSION && type1 == CfscriptTokenTypes.SWITCH_KEYWORD) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.CATCHEXPRESSION && type1 == CfscriptTokenTypes.CATCH_KEYWORD) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
            }
        } else if (elementType == CfmlElementTypes.FUNCTION_DEFINITION && type1 == CfscriptTokenTypes.IDENTIFIER && type2 == CfmlElementTypes.PARAMETERS_LIST) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        }
        if (type1 == CfmlTokenTypes.ATTRIBUTE || type1 == CfmlTokenTypes.ASSIGN && type2 == CfmlTokenTypes.DOUBLE_QUOTE) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (CfmlSpacingProcessor.isAssignmentOperator(type1) || CfmlSpacingProcessor.isAssignmentOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (CfmlSpacingProcessor.isLogicalOperator(type1) || CfmlSpacingProcessor.isLogicalOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
        }
        if (CfmlSpacingProcessor.isEqualityOperator(type1) || CfmlSpacingProcessor.isEqualityOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS);
        }
        if (CfmlSpacingProcessor.isRelationalOperator(type1) || CfmlSpacingProcessor.isRelationalOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
        }
        if (CfmlSpacingProcessor.isAdditiveOperator(type1) || CfmlSpacingProcessor.isAdditiveOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS);
        }
        if (CfmlSpacingProcessor.isMultiplicativeOperator(type1) || CfmlSpacingProcessor.isMultiplicativeOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
        }
        if (CfmlSpacingProcessor.isUnaryOperator(type1) || CfmlSpacingProcessor.isUnaryOperator(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        }
        if (type1 == CfscriptTokenTypes.CONCAT || type2 == CfscriptTokenTypes.CONCAT) {
            return this.addSingleSpaceIf(this.myCfmlSettings.CONCAT_SPACES);
        }
        if (type1 == CfscriptTokenTypes.R_BRACKET) {
            if (type2 == CfscriptTokenTypes.L_CURLYBRACKET && elementType == CfmlElementTypes.SWITCHEXPRESSION) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (type2 == CfmlElementTypes.BLOCK_OF_STATEMENTS) {
                if (elementType == CfmlElementTypes.IFEXPRESSION) {
                    return this.setBraceSpace(this.mySettings.SPACE_BEFORE_IF_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
                }
                if (elementType == CfmlElementTypes.FOREXPRESSION) {
                    return this.setBraceSpace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
                }
                if (elementType == CfmlElementTypes.WHILEEXPRESSION) {
                    return this.setBraceSpace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
                }
            }
        } else {
            if (type1 == CfscriptTokenTypes.ELSE_KEYWORD) {
                if (type2 == CfmlElementTypes.IFEXPRESSION) {
                    return Spacing.createSpacing((int)1, (int)1, (int)(this.mySettings.SPECIAL_ELSE_IF_TREATMENT ? 0 : 1), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
                if (type2 == CfmlElementTypes.BLOCK_OF_STATEMENTS) {
                    return this.setBraceSpace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
                }
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (type1 == CfscriptTokenTypes.TRY_KEYWORD) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (type1 == CfscriptTokenTypes.CATCH_KEYWORD) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_CATCH_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (type1 == CfscriptTokenTypes.DO_KEYWORD) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_DO_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (type1 == CfmlElementTypes.PARAMETERS_LIST && type2 == CfmlElementTypes.FUNCTIONBODY) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, child1.getTextRange());
            }
        }
        if (type2 == CfscriptTokenTypes.ELSE_KEYWORD) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_ELSE_KEYWORD, this.mySettings.ELSE_ON_NEW_LINE);
        }
        if (type2 == CfscriptTokenTypes.WHILE_KEYWORD) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_WHILE_KEYWORD, this.mySettings.WHILE_ON_NEW_LINE);
        }
        if (type2 == CfmlElementTypes.CATCHEXPRESSION) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_CATCH_KEYWORD, this.mySettings.CATCH_ON_NEW_LINE);
        }
        if (type1 == CfscriptTokenTypes.L_BRACKET || type2 == CfscriptTokenTypes.R_BRACKET) {
            if (elementType == CfmlElementTypes.ARGUMENT_LIST) {
                if (type1 == CfscriptTokenTypes.L_BRACKET) {
                    return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE);
                }
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE);
            }
            if (elementType == CfmlElementTypes.PARAMETERS_LIST) {
                if (type1 == CfscriptTokenTypes.L_BRACKET) {
                    return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
                }
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE);
            }
            if (elementType == CfmlElementTypes.IFEXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.FOREXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.WHILEEXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.SWITCHEXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
            }
            if (elementType == CfmlElementTypes.CATCHEXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
            }
            if (this.mySettings.BINARY_OPERATION_WRAP != 0 && type2 == CfmlElementTypes.BINARY_EXPRESSION) {
                return Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP ? 1 : 0), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (this.mySettings.BINARY_OPERATION_WRAP != 0 && type1 == CfmlElementTypes.BINARY_EXPRESSION) {
                return Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP ? 1 : 0), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
        if (elementType == CfmlElementTypes.TERNARY_EXPRESSION) {
            if (type2 == CfscriptTokenTypes.QUESTION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_QUEST);
            }
            if (type1 == CfscriptTokenTypes.QUESTION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_QUEST);
            }
            if (type2 == CfscriptTokenTypes.DOTDOT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_COLON);
            }
            if (type1 == CfscriptTokenTypes.DOTDOT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COLON);
            }
        }
        if (type2 == CfscriptTokenTypes.COMMA) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_COMMA);
        }
        if (type1 == CfscriptTokenTypes.COMMA) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COMMA);
        }
        if (type2 == CfscriptTokenTypes.SEMICOLON) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_SEMICOLON);
        }
        if (type1 == CfscriptTokenTypes.SEMICOLON) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_SEMICOLON);
        }
        return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing addSingleSpaceIf(boolean condition) {
        int spaces = condition ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing addSingleSpaceIf(boolean condition, boolean linesFeed) {
        int spaces = condition ? 1 : 0;
        int lines = linesFeed ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)lines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing setBraceSpace(boolean needSpaceSetting, @CommonCodeStyleSettings.BraceStyleConstant int braceStyleSetting, TextRange textRange) {
        int spaces;
        int n = spaces = needSpaceSetting ? 1 : 0;
        if (braceStyleSetting == 5 && textRange != null) {
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        int lineBreaks = braceStyleSetting == 1 || braceStyleSetting == 5 ? 0 : 1;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)lineBreaks, (boolean)false, (int)0);
    }
}

