/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.files;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlLanguage;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final THashSet<Language> ourRelevantLanguages = new THashSet(Arrays.asList(new Language[]{StdLanguages.HTML, CfmlLanguage.INSTANCE}));

    public CfmlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        CfmlLanguage cfmlLanguage = CfmlLanguage.INSTANCE;
        if (cfmlLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/files/CfmlFileViewProvider", "getBaseLanguage"));
        }
        return cfmlLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        THashSet<Language> tHashSet = ourRelevantLanguages;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/files/CfmlFileViewProvider", "getLanguages"));
        }
        return tHashSet;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/coldFusion/model/files/CfmlFileViewProvider", "createFile"));
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(StdLanguages.HTML)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)CfmlElementTypes.TEMPLATE_DATA);
            return file;
        }
        if (lang == SqlLanguage.INSTANCE) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)SqlLanguage.INSTANCE)).createFile((FileViewProvider)this);
            file.setContentElementType(CfmlElementTypes.SQL_DATA);
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }

    protected CfmlFileViewProvider cloneInner(VirtualFile copy) {
        return new CfmlFileViewProvider(this.getManager(), copy, false);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = StdLanguages.HTML;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/files/CfmlFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }
}

