/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model;

import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlCommentSplitter;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlStringLiteralExpression;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.coldFusion.model.psi.impl.CfmlTagComponentImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<LeafPsiElement> myCfmlCommentTokenizer = TokenizerBase.create((Splitter)CfmlCommentSplitter.INSTANCE);

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof CfmlStringLiteralExpression) {
            Tokenizer tokenizer = new Tokenizer(){

                public void tokenize(final @NotNull PsiElement element, TokenConsumer consumer) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy$1", "tokenize"));
                    }
                    consumer.consumeToken(element, (Splitter)new TextSplitter(){

                        public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
                            if (range == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy$1$1", "split"));
                            }
                            int elementOffset = element.getTextRange().getStartOffset();
                            for (PsiElement e = element.getFirstChild(); e != null; e = e.getNextSibling()) {
                                IElementType type;
                                ASTNode astNode = e.getNode();
                                if (astNode == null || (type = astNode.getElementType()) != CfmlTokenTypes.STRING_TEXT) continue;
                                this.doSplit(text, astNode.getTextRange().shiftRight(-elementOffset), consumer);
                            }
                        }
                    });
                }
            };
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof CfmlReferenceExpression) {
            CfmlAssignmentExpression assignment;
            CfmlVariable var;
            PsiElement parent = element.getParent();
            if (parent instanceof CfmlAssignmentExpression && (var = (assignment = (CfmlAssignmentExpression)parent).getAssignedVariable()) != null && assignment.getAssignedVariableElement() == element) {
                Tokenizer tokenizer = TEXT_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        } else {
            if (element instanceof CfmlTagComponentImpl) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
            if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == CfmlTokenTypes.COMMENT) {
                Tokenizer<LeafPsiElement> tokenizer = this.myCfmlCommentTokenizer;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/CfmlSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

