/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.typedHandlers;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.impl.CfmlTagScriptImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CfmlCommenter
implements Commenter,
SelfManagingCommenter<MyCommenterData> {
    private static final String CF_SCRIPT_BLOCK_COMMENT_PREFIX = "/*";
    private static final String CF_SCRIPT_BLOCK_COMMENT_SUFFIX = "*/";
    private static final String CF_SCRIPT_LINE_COMMENT_PREFIX = "//";
    private static final String CFML_COMMENT_PREFIX = "<!---";
    private static final String CFML_COMMENT_SUFFIX = "--->";

    public String getLineCommentPrefix() {
        return null;
    }

    public String getBlockCommentPrefix() {
        return CFML_COMMENT_PREFIX;
    }

    public String getBlockCommentSuffix() {
        return CFML_COMMENT_SUFFIX;
    }

    public String getCommentedBlockCommentPrefix() {
        return "&lt;!&mdash;";
    }

    public String getCommentedBlockCommentSuffix() {
        return "&mdash;&gt;";
    }

    private static boolean isOffsetWithinCfscript(int offset, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "isOffsetWithinCfscript"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "isOffsetWithinCfscript"));
        }
        PsiElement at = CfmlCommenter.getCfmlElementAtOffset(offset, file);
        if (at != null) {
            CfmlTagScriptImpl scriptTag = (CfmlTagScriptImpl)PsiTreeUtil.getParentOfType((PsiElement)at, CfmlTagScriptImpl.class);
            if (scriptTag != null) {
                return scriptTag.isInsideTag(offset);
            }
            PsiElement firstChild = file.getFirstChild();
            if (firstChild != null) {
                ASTNode theDeepestChild = firstChild.getNode();
                if (theDeepestChild == null) {
                    return false;
                }
                while (theDeepestChild.getFirstChildNode() != null) {
                    theDeepestChild = theDeepestChild.getFirstChildNode();
                }
                IElementType elementType = theDeepestChild.getElementType();
                if (elementType == CfscriptTokenTypes.COMMENT || elementType == CfscriptTokenTypes.COMPONENT_KEYWORD || elementType == CfscriptTokenTypes.INTERFACE_KEYWORD || elementType == CfscriptTokenTypes.IMPORT_KEYWORD) {
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiElement getCfmlElementAtOffset(int offset, PsiFile file) {
        FileViewProvider fileViewProvider = file.getViewProvider();
        file = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        Language cfmlLanguage = file.getLanguage();
        return fileViewProvider.findElementAt(offset, cfmlLanguage);
    }

    private static int skipWhiteSpaces(int offset, PsiFile file) {
        PsiElement at = CfmlCommenter.getCfmlElementAtOffset(offset, file);
        if (at != null && at.getNode().getElementType() == CfmlTokenTypes.WHITE_SPACE) {
            return at.getTextRange().getEndOffset();
        }
        return offset;
    }

    public MyCommenterData createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "createLineCommentingState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "createLineCommentingState"));
        }
        int lineStartOffset = document.getLineStartOffset(startLine);
        return new MyCommenterData(CfmlCommenter.isOffsetWithinCfscript(lineStartOffset, document, file), lineStartOffset);
    }

    public MyCommenterData createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "createBlockCommentingState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "createBlockCommentingState"));
        }
        return new MyCommenterData(CfmlCommenter.isOffsetWithinCfscript(selectionStart, document, file), selectionStart);
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "commentLine"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "commentLine"));
        }
        int originalLineEndOffset = document.getLineEndOffset(line);
        offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
        if (data.isIsWithinCfscript()) {
            document.insertString(offset, (CharSequence)CF_SCRIPT_LINE_COMMENT_PREFIX);
        } else {
            document.insertString(originalLineEndOffset, (CharSequence)CFML_COMMENT_SUFFIX);
            document.insertString(offset, (CharSequence)CFML_COMMENT_PREFIX);
        }
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "uncommentLine"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "uncommentLine"));
        }
        int rangeEnd = document.getLineEndOffset(line);
        if (!data.isIsWithinCfscript()) {
            String commentSuffix = CFML_COMMENT_SUFFIX;
            document.deleteString(rangeEnd - CFML_COMMENT_SUFFIX.length(), rangeEnd);
        }
        String commentPrefix = data.getLineCommentPrefix();
        document.deleteString(offset, offset + commentPrefix.length());
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "isLineCommented"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "isLineCommented"));
        }
        int rangeEnd = document.getLineEndOffset(line);
        boolean commented = true;
        if (!data.isIsWithinCfscript()) {
            String commentSuffix = CFML_COMMENT_SUFFIX;
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(rangeEnd - CFML_COMMENT_SUFFIX.length()), (CharSequence)CFML_COMMENT_SUFFIX)) {
                commented = false;
            }
        }
        String commentPrefix = data.getLineCommentPrefix();
        if (commented && !CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)commentPrefix)) {
            commented = false;
        }
        return commented;
    }

    public String getCommentPrefix(int line, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getCommentPrefix"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getCommentPrefix"));
        }
        return data.getLineCommentPrefix();
    }

    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getBlockCommentRange"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getBlockCommentRange"));
        }
        String commentSuffix = data.getBlockCommentSuffix();
        String commentPrefix = data.getBlockCommentPrefix();
        selectionStart = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)selectionStart, (String)" \t\n");
        selectionEnd = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(selectionEnd - 1), (String)" \t\n") + 1;
        if (selectionEnd < selectionStart) {
            selectionEnd = selectionStart;
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(selectionEnd - commentSuffix.length()), (CharSequence)commentSuffix) && CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)selectionStart, (CharSequence)commentPrefix)) {
            return new TextRange(selectionStart, selectionEnd);
        }
        return null;
    }

    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getBlockCommentPrefix"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getBlockCommentPrefix"));
        }
        return data.getBlockCommentPrefix();
    }

    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getBlockCommentSuffix"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "getBlockCommentSuffix"));
        }
        return data.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, MyCommenterData data) {
        String commentSuffix = data.getBlockCommentSuffix();
        String commentPrefix = data.getBlockCommentPrefix();
        int startBlockLine = document.getLineNumber(startOffset);
        int endBlockLine = document.getLineNumber(endOffset);
        if (document.getCharsSequence().subSequence(document.getLineStartOffset(startBlockLine), document.getLineEndOffset(startBlockLine)).toString().matches("\\s*\\Q" + commentPrefix + "\\E\\s*") && document.getCharsSequence().subSequence(document.getLineStartOffset(endBlockLine), document.getLineEndOffset(endBlockLine)).toString().matches("\\s*\\Q" + commentSuffix + "\\E\\s*")) {
            document.deleteString(document.getLineStartOffset(endBlockLine), document.getLineEndOffset(endBlockLine) + 1);
            document.deleteString(document.getLineStartOffset(startBlockLine), document.getLineEndOffset(startBlockLine) + 1);
            return;
        }
        document.deleteString(endOffset - commentSuffix.length(), endOffset);
        document.deleteString(startOffset, startOffset + commentPrefix.length());
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, MyCommenterData data) {
        int endLineNumber;
        int endLineStart;
        int startLineNumber = document.getLineNumber(startOffset);
        int startLineStart = document.getLineStartOffset(startLineNumber);
        if (startLineStart == startOffset && (endLineStart = document.getLineStartOffset(endLineNumber = document.getLineNumber(endOffset))) == endOffset) {
            String commentStart = data.getBlockCommentPrefix() + "\n";
            String commentEnd = data.getBlockCommentSuffix() + "\n";
            document.insertString(endOffset, (CharSequence)commentEnd);
            document.insertString(startOffset, (CharSequence)commentStart);
            TextRange textRange = new TextRange(startOffset, endOffset + commentStart.length() + commentEnd.length());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "insertBlockComment"));
            }
            return textRange;
        }
        document.insertString(endOffset, (CharSequence)data.getBlockCommentSuffix());
        document.insertString(startOffset, (CharSequence)data.getBlockCommentPrefix());
        TextRange textRange = new TextRange(startOffset, endOffset + data.getBlockCommentSuffix().length() + data.getBlockCommentPrefix().length());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlCommenter", "insertBlockComment"));
        }
        return textRange;
    }

    static class MyCommenterData
    extends CommenterDataHolder {
        private boolean myIsWithinCfscript;
        private int myStartOffset;

        private MyCommenterData(boolean isWithinCfscript, int startOffset) {
            this.myIsWithinCfscript = isWithinCfscript;
            this.myStartOffset = startOffset;
        }

        public boolean isIsWithinCfscript() {
            return this.myIsWithinCfscript;
        }

        public String getLineCommentPrefix() {
            if (this.myIsWithinCfscript) {
                return CfmlCommenter.CF_SCRIPT_LINE_COMMENT_PREFIX;
            }
            return CfmlCommenter.CFML_COMMENT_PREFIX;
        }

        public String getBlockCommentSuffix() {
            if (this.myIsWithinCfscript) {
                return CfmlCommenter.CF_SCRIPT_BLOCK_COMMENT_SUFFIX;
            }
            return CfmlCommenter.CFML_COMMENT_SUFFIX;
        }

        public String getBlockCommentPrefix() {
            if (this.myIsWithinCfscript) {
                return CfmlCommenter.CF_SCRIPT_BLOCK_COMMENT_PREFIX;
            }
            return CfmlCommenter.CFML_COMMENT_PREFIX;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }
    }
}

