/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.server.management.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ServerCommandInterpreter
implements CommandInterpreter {
    private static final String WS_DELIM = " \t\n\r\f";
    private StringTokenizer tok;
    private Object[] commandProviders;
    private String tab = "\t";
    private String newline = "\r\n";
    private PrintWriter out;

    public ServerCommandInterpreter(String cmdLine, Object[] commandProviders, PrintWriter writer) {
        this.commandProviders = commandProviders;
        this.tok = new StringTokenizer(cmdLine);
        this.out = writer;
    }

    public String nextArgument() {
        if (this.tok == null || !this.tok.hasMoreElements()) {
            return null;
        }
        String arg = this.tok.nextToken();
        if (arg.startsWith("\"")) {
            if (arg.endsWith("\"") && arg.length() >= 2) {
                return arg.substring(1, arg.length() - 1);
            }
            String remainingArg = this.tok.nextToken("\"");
            arg = String.valueOf(arg.substring(1)) + remainingArg;
            this.tok.nextToken(WS_DELIM);
        } else if (arg.startsWith("'")) {
            if (arg.endsWith("'") && arg.length() >= 2) {
                return arg.substring(1, arg.length() - 1);
            }
            String remainingArg = this.tok.nextToken("'");
            arg = String.valueOf(arg.substring(1)) + remainingArg;
            this.tok.nextToken(WS_DELIM);
        }
        return arg;
    }

    public Object execute(String cmd) {
        Object retval = null;
        Class[] parameterTypes = new Class[]{CommandInterpreter.class};
        Object[] parameters = new Object[]{this};
        boolean executed = false;
        int size = this.commandProviders.length;
        int i = 0;
        while (!executed && i < size) {
            try {
                Object target = this.commandProviders[i];
                Method method = target.getClass().getMethod("_" + cmd, parameterTypes);
                retval = method.invoke(target, parameters);
                executed = true;
            }
            catch (NoSuchMethodException target) {
            }
            catch (InvocationTargetException ite) {
                executed = true;
                this.printStackTrace(ite.getTargetException());
            }
            catch (Exception ee) {
                executed = true;
                this.printStackTrace(ee);
            }
            ++i;
        }
        if (!executed) {
            i = 0;
            while (i < size) {
                try {
                    CommandProvider commandProvider = (CommandProvider)this.commandProviders[i];
                    this.out.print(commandProvider.getHelp());
                    this.out.flush();
                }
                catch (Exception ee) {
                    this.printStackTrace(ee);
                }
                ++i;
            }
            this.out.print(this.getHelp());
            this.out.flush();
        }
        return retval;
    }

    private void printline(Object o) {
        this.print(o + this.newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object o) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(o);
            this.out.flush();
        }
    }

    public void println() {
        this.println("");
    }

    public void printStackTrace(Throwable t) {
        t.printStackTrace(this.out);
        Method[] methods = t.getClass().getMethods();
        int size = methods.length;
        Class<Throwable> throwable = Throwable.class;
        int i = 0;
        while (i < size) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && throwable.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0) {
                try {
                    Throwable nested = (Throwable)method.invoke((Object)t, null);
                    if (nested != null && nested != t) {
                        this.out.println(ConsoleMsg.CONSOLE_NESTED_EXCEPTION);
                        this.printStackTrace(nested);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object o) {
        if (o == null) {
            return;
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.printline(o);
        }
    }

    public void printDictionary(Dictionary dic, String title) {
        if (dic == null) {
            return;
        }
        int count = dic.size();
        Object[] keys = new String[count];
        Enumeration keysEnum = dic.keys();
        int i = 0;
        while (keysEnum.hasMoreElements()) {
            keys[i++] = (String)keysEnum.nextElement();
        }
        Util.sort((Object[])keys);
        if (title != null) {
            this.println(title);
        }
        i = 0;
        while (i < count) {
            this.println(" " + (String)keys[i] + " = " + dic.get(keys[i]));
            ++i;
        }
        this.println();
    }

    public void printBundleResource(Bundle bundle, String resource) {
        URL entry = null;
        entry = bundle.getEntry(resource);
        if (entry != null) {
            try {
                this.println(resource);
                InputStream in = entry.openStream();
                byte[] buffer = new byte[1024];
                int read = 0;
                try {
                    while ((read = in.read(buffer)) != -1) {
                        this.print(new String(buffer, 0, read));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception e) {
                System.err.println(NLS.bind((String)ConsoleMsg.CONSOLE_ERROR_READING_RESOURCE, (Object)resource));
            }
        } else {
            this.println(NLS.bind((String)ConsoleMsg.CONSOLE_RESOURCE_NOT_IN_BUNDLE, (Object)resource, (Object)bundle.toString()));
        }
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(256);
        help.append(ConsoleMsg.CONSOLE_HELP_CONTROLLING_CONSOLE_HEADING);
        help.append(this.newline);
        help.append(this.tab);
        help.append("more - ");
        help.append(ConsoleMsg.CONSOLE_HELP_MORE);
        help.append(this.newline);
        return help.toString();
    }
}

