/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SearchDialog;

public class StructuralSearchAction
extends AnAction {
    public void actionPerformed(AnActionEvent event) {
        StructuralSearchAction.triggerAction(null, SearchContext.buildFromDataContext(event.getDataContext()));
    }

    public static void triggerAction(Configuration config, SearchContext searchContext) {
        UsageTrigger.trigger((String)"structural.search");
        Project project = searchContext.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        SearchDialog searchDialog = new SearchDialog(searchContext);
        if (config != null) {
            searchDialog.setUseLastConfiguration(true);
            searchDialog.setValuesFromConfig(config);
        }
        searchDialog.show();
    }

    public void update(AnActionEvent event) {
        StructuralSearchPlugin plugin;
        Presentation presentation = event.getPresentation();
        DataContext context = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        StructuralSearchPlugin structuralSearchPlugin = plugin = project == null ? null : StructuralSearchPlugin.getInstance(project);
        if (plugin == null || plugin.isSearchInProgress() || plugin.isDialogVisible()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
        super.update(event);
    }
}

