/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.predicates.AbstractStringBasedPredicate;
import java.util.List;

public class WithinPredicate
extends AbstractStringBasedPredicate {
    private final MatchOptions myMatchOptions = new MatchOptions();
    private Matcher matcher;

    public WithinPredicate(String name, String within, FileType fileType, Project project) {
        super(name, within);
        this.myMatchOptions.setLooseMatching(true);
        this.myMatchOptions.setFileType(fileType);
        String unquoted = StringUtil.stripQuotesAroundValue((String)within);
        if (!unquoted.equals(within)) {
            this.myMatchOptions.setSearchPattern(unquoted);
            PatternCompiler.transformOldPattern(this.myMatchOptions);
            this.matcher = new Matcher(project, this.myMatchOptions);
        } else assert (false);
    }

    @Override
    public boolean match(PsiElement node, PsiElement match, int start, int end, MatchContext context) {
        List<MatchResult> results = this.matcher.matchByDownUp(match, this.myMatchOptions);
        for (MatchResult result : results) {
            if (!PsiTreeUtil.isAncestor((PsiElement)result.getMatch(), (PsiElement)match, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

