/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.impl.matcher.MatchPredicateProvider;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ExprTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.FormalArgTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReadPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.WritePredicate;
import java.util.Set;

public class JavaMatchPredicateProvider
extends MatchPredicateProvider {
    @Override
    public void collectPredicates(MatchVariableConstraint constraint, String name, MatchOptions options, Set<MatchPredicate> predicates) {
        MatchPredicate predicate;
        if (constraint.isReadAccess()) {
            predicate = new ReadPredicate();
            if (constraint.isInvertReadAccess()) {
                predicate = new NotPredicate(predicate);
            }
            predicates.add(predicate);
        }
        if (constraint.isWriteAccess()) {
            predicate = new WritePredicate();
            if (constraint.isInvertWriteAccess()) {
                predicate = new NotPredicate(predicate);
            }
            predicates.add(predicate);
        }
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfExprType())) {
            predicate = new ExprTypePredicate(constraint.getNameOfExprType(), name, constraint.isExprTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults());
            if (constraint.isInvertExprType()) {
                predicate = new NotPredicate(predicate);
            }
            predicates.add(predicate);
        }
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfFormalArgType())) {
            predicate = new FormalArgTypePredicate(constraint.getNameOfFormalArgType(), name, constraint.isFormalArgTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults());
            if (constraint.isInvertFormalType()) {
                predicate = new NotPredicate(predicate);
            }
            predicates.add(predicate);
        }
    }
}

