/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ContentPanel {
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final DefaultActionGroup myActions = new DefaultActionGroup();
    private final ActionToolbar myToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.myActions, false);

    public ContentPanel(JComponent centerComponent) {
        this.myPanel.add((Component)this.myToolbar.getComponent(), "West");
        this.myPanel.add((Component)centerComponent, "Center");
    }

    public void addCloseAction(final ContentManager contentManager, final Content content) {
        this.addAction((AnAction)new CloseTabToolbarAction(){

            public void actionPerformed(AnActionEvent e) {
                contentManager.removeContent(content, true);
            }
        });
    }

    public void addRerunAction(final Runnable rerunner) {
        RefreshAction action = new RefreshAction(){

            public void actionPerformed(AnActionEvent e) {
                rerunner.run();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(true);
            }
        };
        action.getTemplatePresentation().setIcon(AllIcons.Actions.Rerun);
        this.addAction((AnAction)action);
    }

    public void addAction(AnAction action) {
        this.myActions.add(action);
        this.myToolbar.updateActionsImmediately();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void addActionSeparator() {
        this.myActions.addSeparator();
        this.myToolbar.updateActionsImmediately();
    }
}

