/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.XmlDuplocatorState;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class XmlDuplicatesProfile
extends DuplicatesProfileBase {
    private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN});

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/XmlDuplicatesProfile", "isMyLanguage"));
        }
        return language == XMLLanguage.INSTANCE || language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/XmlDuplicatesProfile", "getLanguage"));
        }
        Language language = XmlDuplicatesProfile.getLanguageForElement(element);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/XmlDuplicatesProfile", "getLanguage"));
        }
        return language;
    }

    private static Language getLanguageForElement(PsiElement element) {
        Language fileLanguage;
        PsiFile file;
        if (element.getLanguage() == XMLLanguage.INSTANCE && !(element instanceof XmlFile) && (file = element.getContainingFile()) instanceof XmlFile && (fileLanguage = file.getLanguage()) instanceof XMLLanguage) {
            return fileLanguage;
        }
        return element.getLanguage();
    }

    @Override
    public int getNodeCost(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/XmlDuplicatesProfile", "getNodeCost"));
        }
        return element instanceof XmlTag ? 1 : 0;
    }

    @Override
    public TokenSet getLiterals() {
        return LITERALS;
    }

    @Override
    @NotNull
    public ExternalizableDuplocatorState getDuplocatorState(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/XmlDuplicatesProfile", "getDuplocatorState"));
        }
        ExternalizableDuplocatorState externalizableDuplocatorState = XmlDuplocatorState.getInstance(language);
        if (externalizableDuplocatorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/XmlDuplicatesProfile", "getDuplocatorState"));
        }
        return externalizableDuplocatorState;
    }
}

