/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaLightDuplicateProfileImplementation
implements LightDuplicateProfile {
    private static final int LIMIT = 4;

    JavaLightDuplicateProfileImplementation() {
    }

    @Override
    public void process(final @NotNull LighterAST ast, final @NotNull LightDuplicateProfile.Callback callback) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation", "process"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation", "process"));
        }
        LighterASTNode node = ast.getRoot();
        final IntStack numberOfChildrenIndexedStack = new IntStack();
        final IntStack numberOfNodesIndexedStack = new IntStack();
        final IntStack hashStack = new IntStack();
        final IntStack hash2Stack = new IntStack();
        numberOfChildrenIndexedStack.push(0);
        numberOfNodesIndexedStack.push(0);
        hashStack.push(0);
        hash2Stack.push(0);
        final ArrayList bad = new ArrayList();
        LighterAST wrapperAst = new LighterAST(ast.getCharTable()){

            @NotNull
            public LighterASTNode getRoot() {
                LighterASTNode lighterASTNode = ast.getRoot();
                if (lighterASTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1", "getRoot"));
                }
                return lighterASTNode;
            }

            @Nullable
            public LighterASTNode getParent(@NotNull LighterASTNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1", "getParent"));
                }
                return ast.getParent(node);
            }

            @NotNull
            public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1", "getChildren"));
                }
                List children = ast.getChildren(parent);
                ArrayList<LighterASTNode> good = new ArrayList<LighterASTNode>(children.size());
                for (int i = 0; i < children.size(); ++i) {
                    LighterASTNode node = (LighterASTNode)children.get(i);
                    (JavaLightDuplicateProfileImplementation.hasIndexableChildren(node) ? good : bad).add(node);
                }
                ast.disposeChildren(bad);
                bad.clear();
                ArrayList<LighterASTNode> arrayList = good;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1", "getChildren"));
                }
                return arrayList;
            }

            public void disposeChildren(@NotNull List<LighterASTNode> children) {
                if (children == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1", "disposeChildren"));
                }
                ast.disposeChildren(children);
            }
        };
        RecursiveLighterASTNodeWalkingVisitor visitor = new RecursiveLighterASTNodeWalkingVisitor(wrapperAst){

            public void visitNode(@NotNull LighterASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$2", "visitNode"));
                }
                int hash = JavaLightDuplicateProfileImplementation.nodeHash(element, ast);
                hashStack.push(hash);
                hash2Stack.push(hash);
                int numberOfNodesIndexed = 0;
                int numberOfChildrenIndexed = 0;
                numberOfNodesIndexedStack.push(numberOfNodesIndexed);
                numberOfChildrenIndexedStack.push(numberOfChildrenIndexed);
                if (this.skipVisiting(element, ast)) {
                    return;
                }
                super.visitNode(element);
            }

            private boolean skipVisiting(LighterASTNode element, LighterAST ast2) {
                LighterASTNode methodNameNode;
                if (element.getTokenType() == JavaElementType.METHOD && (methodNameNode = LightTreeUtil.firstChildOfType((LighterAST)ast2, (LighterASTNode)element, (IElementType)JavaTokenType.IDENTIFIER)) != null) {
                    LighterASTNode classNameNode;
                    String methodName = LightTreeUtil.toFilteredString((LighterAST)ast2, (LighterASTNode)methodNameNode, null);
                    if (methodName.equals("hashCode") || methodName.equals("toString") || methodName.equals("equals")) {
                        return true;
                    }
                    LighterASTNode parent = ast2.getParent(element);
                    if (parent != null && parent.getTokenType() == JavaElementType.CLASS && (classNameNode = LightTreeUtil.firstChildOfType((LighterAST)ast2, (LighterASTNode)parent, (IElementType)JavaTokenType.IDENTIFIER)) != null && methodName.equals(LightTreeUtil.toFilteredString((LighterAST)ast2, (LighterASTNode)classNameNode, null))) {
                        return true;
                    }
                }
                return false;
            }

            protected void elementFinished(@NotNull LighterASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$2", "elementFinished"));
                }
                super.elementFinished(element);
                int hash = hashStack.pop();
                int hash2 = hash2Stack.pop();
                int parentHash = hashStack.pop();
                int parentHash2 = hash2Stack.pop();
                int numberOfChildrenIndexed = numberOfChildrenIndexedStack.pop();
                int numberOfNodesIndexed = numberOfNodesIndexedStack.pop();
                int parenNumberOfChildrenIndexed = numberOfChildrenIndexedStack.pop();
                int parentNumberOfNodesIndexed = numberOfNodesIndexedStack.pop();
                IElementType elementType = element.getTokenType();
                boolean includeNodeToHash = JavaLightDuplicateProfileImplementation.toIncludeNodeToHash(element, ast);
                if (elementType == JavaElementType.FOR_STATEMENT) {
                    numberOfNodesIndexed = Math.max(0, numberOfNodesIndexed - 2);
                    numberOfChildrenIndexed = Math.max(0, numberOfChildrenIndexed - 2);
                }
                if (includeNodeToHash && elementType != JavaElementType.CODE_BLOCK) {
                    ++numberOfNodesIndexed;
                }
                if (includeNodeToHash && numberOfNodesIndexed > 4 && (elementType != JavaElementType.CODE_BLOCK || numberOfChildrenIndexed > 4) && hash != 0) {
                    callback.process(hash, hash2 ^= numberOfNodesIndexed - 4 - 1, ast, element);
                }
                if (hash != 0) {
                    parentHash = parentHash * 31 + hash;
                    parentHash2 = parentHash2 * 37 + hash2;
                    parentNumberOfNodesIndexed += numberOfNodesIndexed;
                    ++parenNumberOfChildrenIndexed;
                }
                hashStack.push(parentHash);
                hash2Stack.push(parentHash2);
                numberOfChildrenIndexedStack.push(parenNumberOfChildrenIndexed);
                numberOfNodesIndexedStack.push(parentNumberOfNodesIndexed);
            }
        };
        visitor.visitNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static int nodeHash(LighterASTNode node, LighterAST ast) {
        block57: {
            block55: {
                block56: {
                    block53: {
                        block54: {
                            block47: {
                                block52: {
                                    block50: {
                                        block51: {
                                            block48: {
                                                block49: {
                                                    block45: {
                                                        block46: {
                                                            block41: {
                                                                block44: {
                                                                    block42: {
                                                                        block43: {
                                                                            block37: {
                                                                                block40: {
                                                                                    block38: {
                                                                                        block39: {
                                                                                            block33: {
                                                                                                block36: {
                                                                                                    block34: {
                                                                                                        block35: {
                                                                                                            block31: {
                                                                                                                block32: {
                                                                                                                    children0 = null;
                                                                                                                    children1 = null;
                                                                                                                    try {
                                                                                                                        type = node.getTokenType();
                                                                                                                        if (type != JavaElementType.TYPE) break block31;
                                                                                                                        var5_5 = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET).hashCode();
                                                                                                                        if (children0 == null) break block32;
                                                                                                                    }
                                                                                                                    catch (Throwable var9_26) {
                                                                                                                        if (children0 != null) {
                                                                                                                            ast.disposeChildren(children0);
                                                                                                                        }
                                                                                                                        if (children1 != null) {
                                                                                                                            ast.disposeChildren(children1);
                                                                                                                        }
                                                                                                                        throw var9_26;
                                                                                                                    }
                                                                                                                    ast.disposeChildren(children0);
                                                                                                                }
                                                                                                                if (children1 != null) {
                                                                                                                    ast.disposeChildren(children1);
                                                                                                                }
                                                                                                                return var5_5;
                                                                                                            }
                                                                                                            if (type != JavaElementType.NEW_EXPRESSION) break block33;
                                                                                                            children0 = ast.getChildren(node);
                                                                                                            calledMethod = LightTreeUtil.firstChildOfType((List)children0, (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
                                                                                                            if (calledMethod == null) break block34;
                                                                                                            var6_12 = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)calledMethod, null).hashCode();
                                                                                                            if (children0 == null) break block35;
                                                                                                            ast.disposeChildren(children0);
                                                                                                        }
                                                                                                        if (children1 != null) {
                                                                                                            ast.disposeChildren(children1);
                                                                                                        }
                                                                                                        return var6_12;
                                                                                                    }
                                                                                                    var6_13 = 0;
                                                                                                    if (children0 == null) break block36;
                                                                                                    ast.disposeChildren(children0);
                                                                                                }
                                                                                                if (children1 != null) {
                                                                                                    ast.disposeChildren(children1);
                                                                                                }
                                                                                                return var6_13;
                                                                                            }
                                                                                            if (type != JavaElementType.METHOD_CALL_EXPRESSION) ** GOTO lbl69
                                                                                            children0 = ast.getChildren(node);
                                                                                            calledMethod = LightTreeUtil.firstChildOfType((List)children0, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                                                                                            if (calledMethod == null) break block37;
                                                                                            children1 = ast.getChildren(calledMethod);
                                                                                            qualifierNode = LightTreeUtil.firstChildOfType((List)children1, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                                                                                            if (qualifierNode != null || (identifier = LightTreeUtil.firstChildOfType((List)children1, (IElementType)JavaTokenType.IDENTIFIER)) == null) break block38;
                                                                                            var8_25 = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)identifier, null).hashCode();
                                                                                            if (children0 == null) break block39;
                                                                                            ast.disposeChildren(children0);
                                                                                        }
                                                                                        if (children1 != null) {
                                                                                            ast.disposeChildren(children1);
                                                                                        }
                                                                                        return var8_25;
                                                                                    }
                                                                                    var7_22 = 0;
                                                                                    if (children0 == null) break block40;
                                                                                    ast.disposeChildren(children0);
                                                                                }
                                                                                if (children1 != null) {
                                                                                    ast.disposeChildren(children1);
                                                                                }
                                                                                return var7_22;
                                                                            }
                                                                            break block41;
lbl69:
                                                                            // 1 sources

                                                                            if (type != JavaElementType.REFERENCE_EXPRESSION) break block41;
                                                                            children0 = ast.getChildren(node);
                                                                            qualifierNode = LightTreeUtil.firstChildOfType((List)children0, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                                                                            if (qualifierNode == null || (identifier = LightTreeUtil.firstChildOfType((List)children0, (IElementType)JavaTokenType.IDENTIFIER)) == null) break block42;
                                                                            var7_23 = JavaLightDuplicateProfileImplementation.identifierHash(ast, identifier, qualifierNode);
                                                                            if (children0 == null) break block43;
                                                                            ast.disposeChildren(children0);
                                                                        }
                                                                        if (children1 != null) {
                                                                            ast.disposeChildren(children1);
                                                                        }
                                                                        return var7_23;
                                                                    }
                                                                    identifier = 0;
                                                                    if (children0 == null) break block44;
                                                                    ast.disposeChildren(children0);
                                                                }
                                                                if (children1 != null) {
                                                                    ast.disposeChildren(children1);
                                                                }
                                                                return identifier;
                                                            }
                                                            if (type != JavaElementType.POLYADIC_EXPRESSION && type != JavaElementType.PREFIX_EXPRESSION && type != JavaElementType.POSTFIX_EXPRESSION && type != JavaElementType.ASSIGNMENT_EXPRESSION && type != JavaElementType.BINARY_EXPRESSION) ** GOTO lbl105
                                                            children0 = ast.getChildren(node);
                                                            operationSign = LightTreeUtil.firstChildOfType((List)children0, (TokenSet)ElementType.OPERATION_BIT_SET);
                                                            if (operationSign == null) break block45;
                                                            identifier = operationSign.getTokenType().toString().hashCode();
                                                            if (children0 == null) break block46;
                                                            ast.disposeChildren(children0);
                                                        }
                                                        if (children1 != null) {
                                                            ast.disposeChildren(children1);
                                                        }
                                                        return identifier;
                                                    }
                                                    break block47;
lbl105:
                                                    // 1 sources

                                                    if (type != JavaElementType.LOCAL_VARIABLE) break block48;
                                                    operationSign = 1;
                                                    if (children0 == null) break block49;
                                                    ast.disposeChildren(children0);
                                                }
                                                if (children1 != null) {
                                                    ast.disposeChildren(children1);
                                                }
                                                return operationSign;
                                            }
                                            if (type != JavaElementType.SWITCH_LABEL_STATEMENT) ** GOTO lbl129
                                            children0 = ast.getChildren(node);
                                            caseExpression = LightTreeUtil.firstChildOfType((List)children0, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                                            if (caseExpression == null) break block50;
                                            identifier = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)caseExpression, (TokenSet)ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET).hashCode();
                                            if (children0 == null) break block51;
                                            ast.disposeChildren(children0);
                                        }
                                        if (children1 != null) {
                                            ast.disposeChildren(children1);
                                        }
                                        return identifier;
                                    }
                                    break block47;
lbl129:
                                    // 1 sources

                                    if (type != JavaElementType.LITERAL_EXPRESSION || (children0 = ast.getChildren(node)).isEmpty()) break block47;
                                    childNode = (LighterASTNode)children0.get(0);
                                    identifier = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)childNode, (TokenSet)ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET).hashCode();
                                    if (children0 == null) break block52;
                                    ast.disposeChildren(children0);
                                }
                                if (children1 != null) {
                                    ast.disposeChildren(children1);
                                }
                                return identifier;
                            }
                            if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(type) && !ElementType.EXPRESSION_BIT_SET.contains(type)) break block53;
                            childNode = 1;
                            if (children0 == null) break block54;
                            ast.disposeChildren(children0);
                        }
                        if (children1 != null) {
                            ast.disposeChildren(children1);
                        }
                        return childNode;
                    }
                    if (JavaElementType.EXPRESSION_LIST != type) break block55;
                    children = ast.getChildren(node);
                    numberOfParameters = LightTreeUtil.getChildrenOfType((List)children, (TokenSet)ElementType.EXPRESSION_BIT_SET).size();
                    ast.disposeChildren(children);
                    var7_24 = numberOfParameters;
                    if (children0 == null) break block56;
                    ast.disposeChildren(children0);
                }
                if (children1 != null) {
                    ast.disposeChildren(children1);
                }
                return var7_24;
            }
            var5_11 = 0;
            if (children0 == null) break block57;
            ast.disposeChildren(children0);
        }
        if (children1 != null) {
            ast.disposeChildren(children1);
        }
        return var5_11;
    }

    private static int identifierHash(LighterAST ast, LighterASTNode identifier, LighterASTNode qualifierNode) {
        String qualifierText;
        int identifierHash = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)identifier, null).hashCode();
        LighterASTNode qualifierOfQualifierNode = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)qualifierNode, (TokenSet)ElementType.EXPRESSION_BIT_SET);
        if (qualifierOfQualifierNode == null && StringUtil.isCapitalized((String)(qualifierText = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)qualifierNode, null)))) {
            return identifierHash ^ qualifierText.hashCode();
        }
        return identifierHash;
    }

    private static boolean hasIndexableChildren(LighterASTNode child) {
        IElementType type = child.getTokenType();
        return !ElementType.KEYWORD_BIT_SET.contains(type) && !ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) && JavaElementType.IMPORT_LIST != type && JavaElementType.MODIFIER_LIST != type && JavaElementType.TYPE_PARAMETER_LIST != type && JavaElementType.REFERENCE_PARAMETER_LIST != type && JavaElementType.EXTENDS_LIST != type && JavaElementType.IMPLEMENTS_LIST != type && JavaElementType.THROWS_LIST != type && JavaTokenType.LBRACE != type && JavaTokenType.RBRACE != type && JavaTokenType.LBRACKET != type && JavaTokenType.IDENTIFIER != type && JavaTokenType.RBRACKET != type && JavaTokenType.RPARENTH != type && JavaTokenType.LPARENTH != type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean toIncludeNodeToHash(LighterASTNode node, LighterAST ast) {
        block36: {
            block34: {
                block35: {
                    block30: {
                        block33: {
                            block37: {
                                block31: {
                                    block32: {
                                        block28: {
                                            block29: {
                                                block26: {
                                                    block27: {
                                                        block24: {
                                                            block25: {
                                                                block22: {
                                                                    block23: {
                                                                        children0 = null;
                                                                        children1 = null;
                                                                        try {
                                                                            elementType = node.getTokenType();
                                                                            if (elementType != JavaElementType.CODE_BLOCK) break block22;
                                                                            var5_5 = true;
                                                                            if (children0 == null) break block23;
                                                                        }
                                                                        catch (Throwable var10_18) {
                                                                            if (children0 != null) {
                                                                                ast.disposeChildren(children0);
                                                                            }
                                                                            if (children1 != null) {
                                                                                ast.disposeChildren(children1);
                                                                            }
                                                                            throw var10_18;
                                                                        }
                                                                        ast.disposeChildren(children0);
                                                                    }
                                                                    if (children1 != null) {
                                                                        ast.disposeChildren(children1);
                                                                    }
                                                                    return var5_5;
                                                                }
                                                                if (ElementType.JAVA_STATEMENT_BIT_SET.contains(elementType)) break block24;
                                                                var5_6 = false;
                                                                if (children0 == null) break block25;
                                                                ast.disposeChildren(children0);
                                                            }
                                                            if (children1 != null) {
                                                                ast.disposeChildren(children1);
                                                            }
                                                            return var5_6;
                                                        }
                                                        if (elementType != JavaElementType.BLOCK_STATEMENT) break block26;
                                                        var5_7 = false;
                                                        if (children0 == null) break block27;
                                                        ast.disposeChildren(children0);
                                                    }
                                                    if (children1 != null) {
                                                        ast.disposeChildren(children1);
                                                    }
                                                    return var5_7;
                                                }
                                                if (elementType != JavaElementType.LABELED_STATEMENT && elementType != JavaElementType.CONTINUE_STATEMENT && elementType != JavaElementType.EMPTY_STATEMENT && elementType != JavaElementType.BREAK_STATEMENT) break block28;
                                                var5_8 = false;
                                                if (children0 == null) break block29;
                                                ast.disposeChildren(children0);
                                            }
                                            if (children1 != null) {
                                                ast.disposeChildren(children1);
                                            }
                                            return var5_8;
                                        }
                                        if (elementType != JavaElementType.EXPRESSION_STATEMENT || (expression = LightTreeUtil.firstChildOfType((List)(children0 = ast.getChildren(node)), (TokenSet)ElementType.EXPRESSION_BIT_SET)) == null) break block30;
                                        type = expression.getTokenType();
                                        if (type != JavaElementType.ASSIGNMENT_EXPRESSION) ** GOTO lbl72
                                        expressions = LightTreeUtil.getChildrenOfType((LighterAST)ast, (LighterASTNode)expression, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                                        if (expressions.size() != 2 || ((LighterASTNode)expressions.get(1)).getTokenType() != JavaElementType.REFERENCE_EXPRESSION) break block31;
                                        var8_14 = false;
                                        ast.disposeChildren(expressions);
                                        if (children0 == null) break block32;
                                        ast.disposeChildren(children0);
                                    }
                                    if (children1 != null) {
                                        ast.disposeChildren(children1);
                                    }
                                    return var8_14;
                                }
                                ast.disposeChildren(expressions);
                                break block37;
                                {
                                    catch (Throwable var9_16) {
                                        ast.disposeChildren(expressions);
                                        throw var9_16;
                                    }
                                }
                            }
                            if (type != JavaElementType.METHOD_CALL_EXPRESSION) break block30;
                            children1 = ast.getChildren(expression);
                            ast.disposeChildren(children0);
                            methodCall = LightTreeUtil.firstChildOfType((List)children1, (IElementType)JavaElementType.REFERENCE_EXPRESSION);
                            children0 = methodCall != null ? ast.getChildren(methodCall) : Collections.emptyList();
                            superOrConstructorCall = LightTreeUtil.firstChildOfType((List)children0, (IElementType)JavaTokenType.THIS_KEYWORD);
                            if (superOrConstructorCall == null && methodCall != null) {
                                superOrConstructorCall = LightTreeUtil.firstChildOfType((List)children0, (IElementType)JavaTokenType.SUPER_KEYWORD);
                            }
                            if (superOrConstructorCall == null) break block30;
                            var9_17 = false;
                            if (children0 == null) break block33;
                            ast.disposeChildren(children0);
                        }
                        if (children1 != null) {
                            ast.disposeChildren(children1);
                        }
                        return var9_17;
                    }
                    if (elementType != JavaElementType.SWITCH_LABEL_STATEMENT || (defaultKeyword = LightTreeUtil.firstChildOfType((List)(children0 = ast.getChildren(node)), (IElementType)JavaTokenType.DEFAULT_KEYWORD)) == null) break block34;
                    var6_12 = false;
                    if (children0 == null) break block35;
                    ast.disposeChildren(children0);
                }
                if (children1 != null) {
                    ast.disposeChildren(children1);
                }
                return var6_12;
            }
            var5_10 = true;
            if (children0 == null) break block36;
            ast.disposeChildren(children0);
        }
        if (children1 != null) {
            ast.disposeChildren(children1);
        }
        return var5_10;
    }
}

