/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class SqlPlainEnterProcessor
extends SmartEnterProcessorWithFixers.FixEnterProcessor {
    static SqlStatement getStatement(Editor editor, PsiFile psiFile) {
        IElementType type;
        PsiElement currElement;
        int offset = editor.getCaretModel().getOffset();
        if (offset > 0 && offset == editor.getDocument().getTextLength()) {
            --offset;
        }
        if ((currElement = psiFile.findElementAt(offset)) != null && (SqlTokens.SQL_WHITE_SPACE == (type = currElement.getNode().getElementType()) || SqlTokens.SQL_SEMICOLON == type)) {
            currElement = PsiTreeUtil.prevVisibleLeaf((PsiElement)currElement);
        }
        return (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)currElement, SqlStatement.class);
    }

    public boolean doEnter(PsiElement atCaret, PsiFile file, @NotNull Editor editor, boolean modified) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/smartenter/SqlPlainEnterProcessor", "doEnter"));
        }
        if (!modified) {
            return false;
        }
        SqlStatement statement = SqlPlainEnterProcessor.getStatement(editor, file);
        if (statement != null) {
            int textLength = editor.getDocument().getTextLength();
            int offset = statement.getTextRange().getEndOffset() + 1;
            int move = offset < textLength ? offset : textLength;
            editor.getCaretModel().moveToOffset(move);
            this.plainEnter(editor);
            return true;
        }
        return false;
    }
}

