/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.inline;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.sql.refactoring.inline.SqlInlineActionHandler;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCteInlineHandler
extends SqlInlineActionHandler {
    private static final String REFACTORING_NAME = "Inline CTE";
    private static final String HELP_ID = null;

    public boolean canInlineElement(PsiElement element) {
        SqlNamedQueryDefinitionImpl q = SqlCteInlineHandler.resolveToNamedQueryDefinition(element);
        if (q == null) {
            return false;
        }
        SqlWithClause with = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        return with != null && !with.isRecursive();
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        if (editor.getProject() == null) {
            return;
        }
        SqlNamedQueryDefinitionImpl query = SqlCteInlineHandler.resolveToNamedQueryDefinition(element);
        if (query == null) {
            return;
        }
        Collection refs = ReferencesSearch.search((PsiElement)query, (SearchScope)query.getUseScope(), (boolean)false).findAll();
        if (refs.size() < 2) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"No usages found", (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_NAME, (String)REFACTORING_NAME, () -> SqlCteInlineHandler.inlineOp(editor.getProject(), editor, refs, query), (PsiFile[])new PsiFile[]{element.getContainingFile()}));
    }

    @Nullable
    private static List<PsiElement> inlineSubquery(@NotNull Editor editor, @NotNull PsiElement element, @NotNull Collection<PsiElement> alias, @NotNull SqlNamedQueryDefinitionImpl query) {
        SqlAsExpression asExpression;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineSubquery"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineSubquery"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineSubquery"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineSubquery"));
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query.getParent().getParent(), SqlWithQueryExpression.class);
        if (withEx == null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"With clause can not be found", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        if (withEx.getWithClause().isRecursive()) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"Can not inline recursive CTE", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        if (withEx.getExpression() == null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"With clause without query", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        String subqueryAlias = query.getName();
        if (StringUtil.isEmpty((String)subqueryAlias)) {
            subqueryAlias = "cte_alias";
        }
        if ((asExpression = (SqlAsExpression)ObjectUtils.tryCast((Object)element.getParent(), SqlAsExpression.class)) != null) {
            subqueryAlias = asExpression.getName();
            element.replace((PsiElement)SqlSubqueryUtils.parenthesized(query.getExpression()));
            result.add((PsiElement)asExpression);
        } else {
            result.add(element.replace((PsiElement)SqlSubqueryUtils.aliased(query.getExpression(), subqueryAlias)));
        }
        for (PsiElement a : alias) {
            SqlReferenceExpression identifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)a, SqlReferenceExpression.class);
            if (identifier == null) {
                CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"Alias is not identifier", (String)REFACTORING_NAME, (String)HELP_ID);
                continue;
            }
            identifier.setName(subqueryAlias);
            result.add((PsiElement)identifier);
        }
        return result;
    }

    private static void inlineOp(@NotNull Project project, @NotNull Editor editor, @NotNull Collection<PsiReference> refs, @NotNull SqlNamedQueryDefinitionImpl query) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineOp"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineOp"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineOp"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "inlineOp"));
        }
        ArrayList<PsiElement> substitute = new ArrayList<PsiElement>();
        ArrayList<PsiElement> alias = new ArrayList<PsiElement>();
        SqlCteInlineHandler.classifyRefs(editor, (PsiElement)query, refs, substitute, alias);
        if (substitute.size() != 1) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)(substitute.isEmpty() ? "Nothing to inline" : "Too many places to inline"), (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        List<PsiElement> res = SqlCteInlineHandler.inlineSubquery(editor, (PsiElement)substitute.get(0), alias, query);
        if (res == null || res.size() < 1) {
            return;
        }
        SqlExpression ex = SqlCteInlineHandler.getQueryExpression(editor, query);
        if (ex == null) {
            return;
        }
        int offset = res.get(0).getTextOffset() - ex.getTextRange().getStartOffset();
        ex = SqlSubqueryUtils.removeCteDefinition(query);
        ex = SqlCteInlineHandler.getExpressionFromExOrWithEx(ex);
        int caretOffset = ex.getTextRange().getStartOffset() + offset;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(caretOffset);
    }

    private static SqlExpression getExpressionFromExOrWithEx(SqlExpression ex) {
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class);
        SqlExpression ex2 = withEx != null ? withEx.getExpression() : null;
        return ex2 != null ? ex2 : ex;
    }

    private static SqlExpression getQueryExpression(Editor editor, SqlNamedQueryDefinitionImpl el) {
        SqlWithQueryExpression with = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent().getParent(), SqlWithQueryExpression.class);
        if (with == null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"Failed to find with expression", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        return with.getExpression();
    }

    private static void classifyRefs(@NotNull Editor editor, @NotNull PsiElement exclude, @NotNull Collection<PsiReference> refs, @NotNull Collection<PsiElement> substitute, @NotNull Collection<PsiElement> alias) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "classifyRefs"));
        }
        if (exclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exclude", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "classifyRefs"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "classifyRefs"));
        }
        if (substitute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitute", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "classifyRefs"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/sql/refactoring/inline/SqlCteInlineHandler", "classifyRefs"));
        }
        for (PsiReference ref : refs) {
            PsiElement el = ref.getElement();
            if (el == exclude) continue;
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || el.getNode().getElementType() == SqlCompositeElementTypes.SQL_REFERENCE) {
                alias.add(el);
                continue;
            }
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                substitute.add(el);
                continue;
            }
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)"Unexpected reference type", (String)REFACTORING_NAME, (String)HELP_ID);
        }
    }

    @Nullable
    private static SqlNamedQueryDefinitionImpl resolveToNamedQueryDefinition(@Nullable PsiElement element) {
        return (SqlNamedQueryDefinitionImpl)((Object)ObjectUtils.tryCast((Object)element, SqlNamedQueryDefinitionImpl.class));
    }
}

