/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlExtractVariableHelper {
    @Nullable
    public PsiElement findInitializerAnchor(@NotNull List<PsiElement> occurrences) {
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "com/intellij/sql/refactoring/SqlExtractVariableHelper", "findInitializerAnchor"));
        }
        return SqlExtractVariableHelper.findAnchor(occurrences, SqlBlockStatementImpl.class);
    }

    @Nullable
    private static PsiElement findAnchor(@NotNull List<PsiElement> occurrences, @NotNull Class<? extends SqlElement> clazz) {
        PsiElement e;
        int minOffset;
        PsiElement block;
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "com/intellij/sql/refactoring/SqlExtractVariableHelper", "findAnchor"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/refactoring/SqlExtractVariableHelper", "findAnchor"));
        }
        PsiElement anchor = (PsiElement)ContainerUtil.getFirstItem(occurrences);
        if (anchor == null) {
            return null;
        }
        block0: while (true) {
            block = PsiTreeUtil.getParentOfType((PsiElement)anchor, clazz);
            minOffset = Integer.MAX_VALUE;
            for (PsiElement element : occurrences) {
                minOffset = Math.min(minOffset, element.getTextOffset());
                if (PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)element, (boolean)true)) continue;
                if (block == null) {
                    return null;
                }
                anchor = block;
                continue block0;
            }
            break;
        }
        if (block == null) {
            return null;
        }
        PsiElement child = null;
        Iterator iterator = SqlImplUtil.sqlChildren(block).iterator();
        while (iterator.hasNext() && !(child = (e = (PsiElement)iterator.next())).getTextRange().contains(minOffset)) {
        }
        return child;
    }

    @Nullable
    public abstract PsiElement createDeclaration(@NotNull Project var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public abstract PsiElement createInitializerDeclaration(@NotNull Project var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public abstract SqlTypeElement getTypeElement(@NotNull PsiElement var1);

    public abstract PsiElement addDeclaration(@NotNull PsiElement var1, @NotNull PsiElement var2);

    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element) {
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlBlockStatementImpl.class);
    }
}

