/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExtractNamedQueryAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        this.invoke(SqlExtractNamedQueryAction.getEditor(e), SqlExtractNamedQueryAction.getPsiFile(e));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Editor editor = SqlExtractNamedQueryAction.getEditor(e);
        PsiFile file = SqlExtractNamedQueryAction.getPsiFile(e);
        boolean visible = editor != null && file != null;
        boolean enabled = visible;
        if (enabled) {
            SqlExpression subquery = SqlSubqueryUtils.smartFindQuery(editor, file);
            SqlExpression query = SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)subquery);
            enabled = SqlSubqueryUtils.isSubquery(query, subquery) && SqlExtractNamedQueryAction.isCTESupported(file);
        }
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
    }

    public void invoke(Editor editor, PsiFile file) {
        if (!SqlExtractNamedQueryAction.isCTESupported(file)) {
            return;
        }
        SqlExpression subquery = SqlSubqueryUtils.smartFindQuery(editor, file);
        SqlExpression query = SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)subquery);
        if (!SqlSubqueryUtils.isSubquery(query, subquery)) {
            return;
        }
        SqlSubqueryUtils.extractCte(editor.getProject(), editor, file, subquery, query);
    }

    private static boolean isCTESupported(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/refactoring/SqlExtractNamedQueryAction", "isCTESupported"));
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDatabaseDialect().supportsCommonTableExpression();
    }

    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/refactoring/SqlExtractNamedQueryAction", "getEditor"));
        }
        return (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/refactoring/SqlExtractNamedQueryAction", "getPsiFile"));
        }
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
    }
}

