/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlTableElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlTableStub
extends SqlNamedElementStub<SqlTableDefinition> {
    private final StringRef myExpressionText;
    private final StringRef[][] myAncestorTextRefs;
    private SqlExpression myExpression;
    private List<SqlReferenceExpression>[] myAncestorRefs;

    protected SqlTableStub(StubElement parent, @NotNull SqlTableElementType elementType, StringRef name, StringRef expressionText, StringRef[][] ancestorRefs) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/SqlTableStub", "<init>"));
        }
        super(parent, elementType, name);
        this.myExpressionText = expressionText;
        this.myAncestorTextRefs = ancestorRefs;
        this.myAncestorRefs = ancestorRefs == null ? null : new List[ancestorRefs.length];
    }

    public String getExpressionText() {
        return this.myExpressionText == null ? null : this.myExpressionText.getString();
    }

    public StringRef[][] getAncestorTextRefs() {
        return this.myAncestorTextRefs;
    }

    public SqlExpression getExpression() {
        String text;
        if (this.myExpression == null && StringUtil.isNotEmpty((String)(text = this.getExpressionText()))) {
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            this.myExpression = SqlPsiElementFactory.createQueryExpressionFromText(text, SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return this.myExpression;
    }

    @NotNull
    public List<SqlReferenceExpression> getAncestorRefs(int idx) {
        if (this.myAncestorRefs == null || idx < this.myAncestorRefs.length || idx >= this.myAncestorRefs.length) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableStub", "getAncestorRefs"));
            }
            return list;
        }
        if (this.myAncestorRefs[idx] == null) {
            StringRef[] refs = this.myAncestorTextRefs[idx];
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            this.myAncestorRefs[idx] = ContainerUtil.newArrayListWithCapacity((int)refs.length);
            for (StringRef ref : refs) {
                this.myAncestorRefs[idx].add(SqlPsiElementFactory.createReferenceFromText(ref.getString(), SqlImplUtil.getSqlDialectSafe((PsiElement)psi), SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (PsiElement)psi));
            }
        }
        List<SqlReferenceExpression> list = this.myAncestorRefs[idx];
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableStub", "getAncestorRefs"));
        }
        return list;
    }
}

