/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.stubs.SqlAllNameIndex;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlTableKeyElementType<T extends SqlKIFKImpl<?>>
extends SqlStubElementType<SqlTableKeyStub<T>, T> {
    public static final NotNullFunction<String, SqlTableKeyElementType> FACTORY = name -> new SqlTableKeyElementType((String)name);

    public static <T extends SqlKIFKImpl<?>> NotNullFunction<String, SqlTableKeyElementType<T>> factory() {
        return FACTORY;
    }

    protected SqlTableKeyElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "<init>"));
        }
        super(debugName);
    }

    @NotNull
    public SqlTableKeyStub<T> createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "createStub"));
        }
        String tableName = ((SqlKIFKImpl)((Object)psi)).getTableName();
        Iterable columnNames = ((SqlKIFKImpl)((Object)psi)).getColumnsRef().names();
        String keyText = tableName == null ? null : SqlTableKeyElementType.tableColumnList(tableName, columnNames);
        SqlNameElement nameElement = ((SqlStubbedDefinitionImpl)((Object)psi)).getNameElement();
        boolean unique = false;
        if (psi instanceof SqlIndexDefinition) {
            unique = ((SqlIndexDefinition)psi).isUnique();
        }
        SqlTableKeyStub sqlTableKeyStub = new SqlTableKeyStub(parentStub, this, SqlTableKeyElementType.asStringRef((PsiElement)nameElement), keyText == null ? null : StringRef.fromString((String)keyText), unique);
        if (sqlTableKeyStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "createStub"));
        }
        return sqlTableKeyStub;
    }

    @Override
    public void indexStub(@NotNull SqlTableKeyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "indexStub"));
        }
        SqlTableKeyElementType.indexNamedStub(stub, SqlAllNameIndex.KEY, sink);
    }

    public void serialize(@NotNull SqlTableKeyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getKeyText());
        dataStream.writeBoolean(stub.isUnique());
    }

    @NotNull
    public SqlTableKeyStub<T> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "deserialize"));
        }
        SqlTableKeyStub sqlTableKeyStub = new SqlTableKeyStub(parentStub, this, dataStream.readName(), dataStream.readName(), dataStream.readBoolean());
        if (sqlTableKeyStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlTableKeyElementType", "deserialize"));
        }
        return sqlTableKeyStub;
    }

    static String tableColumnList(String tableName, Iterable<String> columnNames) {
        if (Iterables.isEmpty(columnNames)) {
            return tableName;
        }
        return tableName + "(" + StringUtil.join(columnNames, (String)",") + ")";
    }
}

