/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.support;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SqlAltNamesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SqlAltNamesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/psi/impl/support/SqlAltNamesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/sql/psi/impl/support/SqlAltNamesSearcher", "processQuery"));
        }
        PsiElement refElement = p.getElementToSearch();
        SqlAltNamesProvider alt = (SqlAltNamesProvider)ObjectUtils.tryCast((Object)refElement, SqlAltNamesProvider.class);
        if (alt == null) {
            return;
        }
        SearchScope searchScope = p.getEffectiveSearchScope();
        for (String text : alt.getAltNames()) {
            if (!StringUtil.isNotEmpty((String)text)) continue;
            p.getOptimizer().searchWord(text, searchScope, refElement.getLanguage().isCaseSensitive(), refElement);
        }
    }
}

