/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubtractedSqlTableTypeImpl
extends SqlTableTypeBase {
    private final SqlTableType myType;
    private final int myIndex;

    public SubtractedSqlTableTypeImpl(@NotNull SqlTableType type, @Nullable PsiElement element) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SubtractedSqlTableTypeImpl", "<init>"));
        }
        this.myType = type;
        int index = -1;
        int count = this.myType.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            if (!this.myType.getColumnElement(i2).isEquivalentTo(element)) continue;
            index = i2;
            break;
        }
        this.myIndex = index;
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myType.getTypeElement();
    }

    private boolean before(int i2) {
        return this.myIndex >= 0 && i2 < this.myIndex;
    }

    public int getColumnCount() {
        if (this.myIndex >= 0) {
            return this.myType.getColumnCount() - 1;
        }
        return this.myType.getColumnCount();
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        if (this.before(i2)) {
            return this.myType.getColumnQualifier(i2);
        }
        return this.myType.getColumnQualifier(i2 + 1);
    }

    public String getColumnName(int i2) {
        if (this.before(i2)) {
            return this.myType.getColumnName(i2);
        }
        return this.myType.getColumnName(i2 + 1);
    }

    public SqlType getColumnType(int i2) {
        if (this.before(i2)) {
            return this.myType.getColumnType(i2);
        }
        return this.myType.getColumnType(i2 + 1);
    }

    public DataType getDataType(int i2) {
        if (this.before(i2)) {
            return this.myType.getDataType(i2);
        }
        return this.myType.getDataType(i2 + 1);
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        if (this.before(i2)) {
            PsiElement psiElement = this.myType.getColumnElement(i2);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SubtractedSqlTableTypeImpl", "getColumnElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = this.myType.getColumnElement(i2 + 1);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SubtractedSqlTableTypeImpl", "getColumnElement"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getSourceColumnElement(int i2) {
        if (this.before(i2)) {
            return this.myType.getSourceColumnElement(i2);
        }
        return this.myType.getSourceColumnElement(i2 + 1);
    }
}

