/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableTypeComposite
extends SqlTableTypeBase {
    private final SqlTableType myType1;
    private final SqlTableType myType2;
    private final int myCount1;
    private final int myCount2;

    public static SqlTableType join(@NotNull SqlTableType type1, @NotNull SqlTableType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "join"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "join"));
        }
        if (type1 == SqlTableTypeBase.EMPTY_TABLE) {
            return type2;
        }
        if (type2 == SqlTableTypeBase.EMPTY_TABLE) {
            return type1;
        }
        return new SqlTableTypeComposite(type1, type2){

            @Override
            @Nullable
            public PsiElement getTypeElement() {
                return null;
            }
        };
    }

    public static SqlTableType add(@NotNull SqlTableType type1, @NotNull SqlTableType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "add"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "add"));
        }
        if (type1 == SqlTableTypeBase.EMPTY_TABLE) {
            return type2;
        }
        if (type2 == SqlTableTypeBase.EMPTY_TABLE) {
            return type1;
        }
        final PsiElement psiElement = Comparing.equal((Object)type1.getTypeElement(), (Object)type2.getTypeElement()) ? type2.getTypeElement() : null;
        return new SqlTableTypeComposite(type1, type2){

            @Override
            @Nullable
            public PsiElement getTypeElement() {
                return psiElement;
            }
        };
    }

    private SqlTableTypeComposite(@NotNull SqlTableType type1, @NotNull SqlTableType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "<init>"));
        }
        this.myType1 = type1;
        this.myType2 = type2;
        this.myCount1 = this.myType1.getColumnCount();
        this.myCount2 = this.myType2.getColumnCount();
    }

    public int getColumnCount() {
        return this.myCount1 + this.myCount2;
    }

    public String getColumnName(int i2) {
        int cnt = this.myCount1;
        return i2 < cnt ? this.myType1.getColumnName(i2) : this.myType2.getColumnName(i2 - cnt);
    }

    public SqlType getColumnType(int i2) {
        int cnt = this.myCount1;
        return i2 < cnt ? this.myType1.getColumnType(i2) : this.myType2.getColumnType(i2 - cnt);
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        int cnt = this.myCount1;
        return i2 < cnt ? this.myType1.getColumnQualifier(i2) : this.myType2.getColumnQualifier(i2 - cnt);
    }

    public DataType getDataType(int i2) {
        int cnt = this.myCount1;
        return i2 < cnt ? this.myType1.getDataType(i2) : this.myType2.getDataType(i2 - cnt);
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        int cnt = this.myCount1;
        PsiElement psiElement = i2 < cnt ? this.myType1.getColumnElement(i2) : this.myType2.getColumnElement(i2 - cnt);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTableTypeComposite", "getColumnElement"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getSourceColumnElement(int i2) {
        int cnt = this.myCount1;
        return i2 < cnt ? this.myType1.getSourceColumnElement(i2) : this.myType2.getSourceColumnElement(i2 - cnt);
    }

    @Override
    @Nullable
    public String getColumnTypeAlias(int i2) {
        int cnt = this.myCount1;
        return i2 < cnt ? this.myType1.getColumnTypeAlias(i2) : this.myType2.getColumnTypeAlias(i2 - cnt);
    }
}

