/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlHierarchicalClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import org.jetbrains.annotations.NotNull;

public class SqlTableExpressionImpl
extends SqlExpressionImpl
implements SqlTableExpression {
    public SqlTableExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlTableExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTableExpression((SqlTableExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlTableExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlTableExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlTableExpressionImpl", "processDeclarations"));
        }
        SqlFromClause fromClause = this.getFromClause();
        if (fromClause != null && lastParent != fromClause && !fromClause.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        SqlHierarchicalClause hierarchicalClause = this.getHierarchicalClause();
        return hierarchicalClause == null || lastParent == hierarchicalClause || hierarchicalClause.processDeclarations(processor, state, lastParent, place);
    }

    public SqlHierarchicalClause getHierarchicalClause() {
        return (SqlHierarchicalClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE);
    }

    public SqlFromClause getFromClause() {
        return (SqlFromClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_FROM_CLAUSE);
    }

    public SqlWhereClause getWhereClause() {
        return (SqlWhereClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_WHERE_CLAUSE);
    }

    public SqlGroupByClause getGroupByClause() {
        return (SqlGroupByClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE);
    }

    public SqlOrderByClause getOrderByClause() {
        return (SqlOrderByClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE);
    }

    public SqlWhenClause getWhenClause() {
        return (SqlWhenClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_WHEN_CLAUSE);
    }

    public SqlHavingClause getHavingClause() {
        return (SqlHavingClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_HAVING_CLAUSE);
    }

    @NotNull
    public SqlTableType getSqlType() {
        SqlFromClause fromClause = this.getFromClause();
        SqlExpression expression = fromClause == null ? null : fromClause.getFromExpression();
        SqlType type = expression == null ? null : expression.getSqlType();
        SqlTableType sqlTableType = type instanceof SqlTableType ? (SqlTableType)type : SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTableExpressionImpl", "getSqlType"));
        }
        return sqlTableType;
    }
}

