/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralManipulator
extends AbstractElementManipulator<SqlStringLiteralExpressionImpl> {
    public SqlStringLiteralExpressionImpl handleContentChange(@NotNull SqlStringLiteralExpressionImpl psi, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/impl/SqlStringLiteralManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/sql/psi/impl/SqlStringLiteralManipulator", "handleContentChange"));
        }
        String oldText = psi.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + SqlStringLiteralManipulator.escapeSqlStringCharacters(newContent, SqlStringLiteralManipulator.getStringTokenType(psi)) + oldText.substring(range.getEndOffset());
        return psi.updateText(newText);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull SqlStringLiteralExpressionImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlStringLiteralManipulator", "getRangeInElement"));
        }
        TextRange textRange = SqlStringLiteralManipulator.getStringTokenRange(element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringLiteralManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public static String unescapeSqlStringCharacters(String text, IElementType tokenType) {
        return tokenType == SqlTokens.SQL_STRING_TOKEN ? text.replace("''", "'") : text;
    }

    public static String escapeSqlStringCharacters(String text, IElementType tokenType) {
        return tokenType == SqlTokens.SQL_STRING_TOKEN ? text.replace("'", "''") : text;
    }

    public static IElementType getStringTokenType(SqlStringLiteralExpression expression) {
        SqlStringTokenElement type = SqlStringLiteralManipulator.getStringToken(expression);
        return type == null ? SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN : type.getElementType();
    }

    @Nullable
    public static SqlStringTokenElement getStringToken(SqlStringLiteralExpression expression) {
        return (SqlStringTokenElement)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlStringTokenElement.class);
    }

    public static TextRange getStringTokenRange(SqlStringLiteralExpressionImpl element) {
        SqlStringTokenElement stringToken = SqlStringLiteralManipulator.getStringToken(element);
        if (stringToken != null) {
            return stringToken.getRangeInElement().shiftRight(stringToken.getStartOffsetInParent());
        }
        ASTNode quote = element.getNode().findChildByType((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE);
        assert (quote instanceof LeafPsiElement) : element.getText();
        return TextRange.from((int)(((LeafPsiElement)quote).getStartOffsetInParent() + quote.getTextLength()), (int)0);
    }
}

