/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveCacheImpl
implements SqlResolveCache {
    private final Map<String, Pair<PsiElement, ResolveResult[]>> myMap = ContainerUtil.newConcurrentMap();

    @Override
    @Nullable
    public ResolveResult[] getResult(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/SqlResolveCacheImpl", "getResult"));
        }
        String text = ref.getElement().getText();
        Pair<PsiElement, ResolveResult[]> pair = this.myMap.get(text);
        if (pair != null) {
            PsiElement element = SqlResolveCacheImpl.calculateContext(ref);
            if (element == null) {
                return null;
            }
            if (element.isEquivalentTo((PsiElement)pair.first)) {
                return (ResolveResult[])pair.second;
            }
        }
        return null;
    }

    @Override
    public void cacheResult(@NotNull PsiReference ref, @NotNull ResolveResult[] computed) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/SqlResolveCacheImpl", "cacheResult"));
        }
        if (computed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computed", "com/intellij/sql/psi/impl/SqlResolveCacheImpl", "cacheResult"));
        }
        PsiElement element = SqlResolveCacheImpl.calculateContext(ref);
        if (element != null) {
            String text = ref.getElement().getText();
            this.myMap.put(text, (Pair<PsiElement, ResolveResult[]>)Pair.create((Object)element, (Object)computed));
        }
    }

    @Nullable
    private static PsiElement calculateContext(PsiReference ref) {
        if (!(ref instanceof SqlReferenceImpl)) {
            return null;
        }
        PsiElement e = ref.getElement();
        if (e == null) {
            return null;
        }
        SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getParentOfType((PsiElement)e, SqlWhereClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
        if (where != null) {
            return where;
        }
        if (((SqlReferenceImpl)ref).getReferenceElementType().getTargetKind() == ObjectKind.TABLE) {
            SqlExpression tgt;
            SqlDmlInstruction dml = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)e, SqlDmlInstruction.class);
            SqlExpression sqlExpression = tgt = dml == null ? null : dml.getTargetExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)tgt, (PsiElement)e, (boolean)false)) {
                NavigatablePsiElement context = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)dml, (Class[])new Class[]{SqlBlockStatementImpl.class, SqlFile.class});
                if (context instanceof SqlFile) {
                    SqlImportState info = SqlDialectImplUtil.getNearestImportState(e, SqlDialectImplUtil.buildImports((SqlFile)context));
                    return info.element != null ? info.element : context;
                }
                return context;
            }
        }
        return null;
    }
}

