/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReferenceExpressionImpl
extends SqlExpressionImpl
implements SqlReferenceExpression,
PsiMetaData,
PsiMetaOwner {
    private final SqlReferenceImpl myReference;

    public SqlReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "<init>"));
        }
        super(node);
        this.myReference = new SqlReferenceImpl((SqlElement)this){

            @Override
            @Nullable
            public SqlExpression getQualifierExpression() {
                return SqlReferenceExpressionImpl.this.getQualifierExpression();
            }

            @Override
            public String getReferenceName() {
                return SqlReferenceExpressionImpl.this.getName();
            }

            @Override
            protected boolean shouldProcessFunctionVariants() {
                return SqlReferenceExpressionImpl.this.getIdentifier() != null;
            }

            public TextRange getRangeInElement() {
                SqlIdentifier identifier = SqlReferenceExpressionImpl.this.getIdentifier();
                if (identifier != null) {
                    return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                }
                PsiElement element = SqlReferenceExpressionImpl.this.findChildByType((IElementType)SqlTokens.SQL_PERIOD);
                return new TextRange(element != null ? element.getStartOffsetInParent() + 1 : 0, SqlReferenceExpressionImpl.this.getTextLength());
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                SqlImplUtil.setReferenceName(SqlReferenceExpressionImpl.this, newElementName);
                return SqlReferenceExpressionImpl.this;
            }
        };
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlReferenceExpression((SqlReferenceExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "processDeclarations"));
        }
        return !(lastParent instanceof SqlClause) || lastParent.getParent() != this || SqlImplUtil.processQualifierImpl(this, processor, state, place);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType sqlType = this.myReference.getSqlType();
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getSqlType"));
        }
        return sqlType;
    }

    @Nullable
    public SqlExpression getQualifierExpression() {
        return (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    @Nullable
    public SqlIdentifier getIdentifier() {
        SqlIdentifier identifier = (SqlIdentifier)this.findChildByClass(SqlIdentifier.class);
        if (identifier == null) {
            PsiElement lastChild = this.getLastChild();
            if (this.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
                identifier = ((SqlReferenceExpression)lastChild).getIdentifier();
            }
        }
        return identifier;
    }

    public PsiElement getDeclaration() {
        return this.resolve();
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        SqlIdentifier identifier = this.getIdentifier();
        if (identifier != null) {
            String string = identifier.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getName"));
            }
            return string;
        }
        PsiElement child = this.getLastChild();
        if (child instanceof SqlLiteralExpression) {
            String string = child.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getName"));
            }
            return string;
        }
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getName"));
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isPlainIdentifier() {
        SqlIdentifier identifier = this.getIdentifier();
        return identifier != null && identifier.isPlainIdentifier();
    }

    public boolean isQuotedIdentifier() {
        SqlIdentifier identifier = this.getIdentifier();
        return identifier != null && identifier.isQuotedIdentifier();
    }

    public SqlNameElement setName(String newElementName) throws IncorrectOperationException {
        SqlImplUtil.setReferenceName(this, newElementName);
        return this;
    }

    @NotNull
    public SqlReferenceImpl getReference() {
        SqlReferenceImpl sqlReferenceImpl = this.myReference;
        if (sqlReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getReference"));
        }
        return sqlReferenceImpl;
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return this.getReference().multiResolve(incompleteCode);
    }

    public PsiElement resolve() {
        return this.getReference().resolve();
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        SqlReferenceElementType sqlReferenceElementType = this.myReference.getReferenceElementType();
        if (sqlReferenceElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getReferenceElementType"));
        }
        return sqlReferenceElementType;
    }

    @NotNull
    public String getReferencePart(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getReferencePart"));
        }
        String string = SqlImplUtil.getCasedPart(this, kind);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlReferenceExpressionImpl", "getReferencePart"));
        }
        return string;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }
}

