/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.usageView.UsageViewTypeLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlElementDescriptionProvider
implements ElementDescriptionProvider {
    @Nullable
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlElementDescriptionProvider", "getElementDescription"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/sql/psi/impl/SqlElementDescriptionProvider", "getElementDescription"));
        }
        if (!(element instanceof SqlDefinition)) {
            return null;
        }
        SqlDefinition definition = (SqlDefinition)element;
        if (location == UsageViewTypeLocation.INSTANCE) {
            return SqlElementDescriptionProvider.getKindName(definition);
        }
        return definition.getName();
    }

    @NotNull
    public static String getKindName(SqlDefinition e) {
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)e).getDatabaseDialect();
        String string = DbPresentation.getPresentableName((ObjectKind)e.getKind(), (DatabaseDialect)dialect);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlElementDescriptionProvider", "getKindName"));
        }
        return string;
    }
}

