/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionUtil {
    private static final InsertHandler<LookupElement> DOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, LookupElement item) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$1", "handleInsert"));
            }
            if (context.getCompletionChar() != '.') {
                boolean alreadyDot;
                String text = context.getDocument().getText();
                boolean bl = alreadyDot = text.length() > context.getTailOffset() && text.charAt(context.getTailOffset()) == '.';
                if (!alreadyDot) {
                    context.getDocument().insertString(context.getTailOffset(), (CharSequence)".");
                }
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
            }
        }
    };
    public static final InsertHandler<LookupElement> QUOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int endOff;
            boolean rightIsQuote;
            char leftChar;
            String toInsertQuoted;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$2", "handleInsert"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/sql/psi/impl/SqlCompletionUtil$2", "handleInsert"));
            }
            DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)context.getFile()).getDatabaseDialect();
            String toInsert = item.getLookupString();
            if (toInsert.equals(toInsertQuoted = dialect.quoteIdentifier(toInsert, false, false))) {
                return;
            }
            Document document = context.getDocument();
            CharSequence text = document.getCharsSequence();
            int start = context.getStartOffset();
            int end = context.getTailOffset();
            char c = leftChar = start > 0 ? text.charAt(start - 1) : (char)'\u0000';
            char rightExpected = leftChar == dialect.openQuote() ? dialect.closeQuote() : (leftChar == '\"' ? (char)'\"' : '\u0000');
            boolean leftIsQuote = rightExpected != '\u0000';
            char rightChar = end < document.getTextLength() ? text.charAt(end) : (char)'\u0000';
            boolean bl = rightIsQuote = rightChar == dialect.closeQuote() || rightChar == '\"';
            if (!leftIsQuote) {
                document.insertString(start, (CharSequence)toInsertQuoted.substring(0, 1));
            }
            int n = endOff = !leftIsQuote ? 1 : 0;
            if (leftIsQuote && (!rightIsQuote || rightExpected != rightChar)) {
                document.insertString(end + endOff, (CharSequence)String.valueOf(rightExpected));
            } else if (!leftIsQuote) {
                document.insertString(end + endOff, (CharSequence)toInsertQuoted.substring(toInsertQuoted.length() - 1, toInsertQuoted.length()));
            }
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }
    };
    private static final InsertHandler<LookupElement> QUOT_DOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$3", "handleInsert"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/sql/psi/impl/SqlCompletionUtil$3", "handleInsert"));
            }
            QUOT_INSERT_HANDLER.handleInsert(context, item);
            DOT_INSERT_HANDLER.handleInsert(context, item);
        }
    };
    public static final InsertHandler<LookupElement> NEW_LINE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, LookupElement item) {
            int lineEnd;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$4", "handleInsert"));
            }
            String text = context.getDocument().getText();
            boolean insert = true;
            int offset = context.getTailOffset();
            if (text.length() > offset && (lineEnd = context.getDocument().getLineEndOffset(context.getDocument().getLineNumber(offset))) > offset && !StringUtil.isEmptyOrSpaces((String)context.getDocument().getText(TextRange.create((int)offset, (int)lineEnd)))) {
                insert = false;
            }
            if (insert) {
                context.getDocument().insertString(offset, (CharSequence)"\n");
                context.getEditor().getCaretModel().moveToOffset(offset + 1);
            }
        }
    };
    public static final BasicInsertHandler<LookupElement> DUMMY_HANDLER = new BasicInsertHandler();

    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @NotNull Consumer<LookupElement> resultSet, boolean addDot, double forcePriority) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addLookupElement"));
        }
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addLookupElement"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addLookupElement"));
        }
        return SqlCompletionUtil.addLookupElement(dialect, t, null, resultSet, addDot, forcePriority, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Object t, @Nullable PsiElement forcedContext, @NotNull Consumer<LookupElement> resultSet, boolean addDot, double forcePriority, @Nullable PsiElement psiElement) {
        void context;
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addLookupElement"));
        }
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addLookupElement"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addLookupElement"));
        }
        DatabaseDialectEx databaseDialect = dialect.getDatabaseDialect();
        if (t instanceof SqlAsExpression) {
            return SqlCompletionUtil.forAlias((SqlAsExpression)t, resultSet, databaseDialect);
        }
        if (t instanceof SqlFunctionDefinition) {
            return SqlCompletionUtil.forSqlFunction(dialect, (SqlFunctionDefinition)((Object)t), resultSet);
        }
        if (t instanceof DasRoutine && t instanceof PsiNamedElement) {
            return SqlCompletionUtil.forProcedureInfo((PsiNamedElement)t, resultSet, databaseDialect, (PsiElement)context);
        }
        if (t instanceof PsiNamedElement && !(t instanceof SqlReferenceExpression)) {
            return SqlCompletionUtil.forPsiNamedElement((PsiNamedElement)t, forcedContext, resultSet, addDot, forcePriority, databaseDialect, (PsiElement)context);
        }
        if (t instanceof SqlReferenceExpression) {
            return SqlCompletionUtil.forSqlReference((SqlReferenceExpression)t, resultSet, (PsiElement)context);
        }
        return false;
    }

    public static boolean forSqlReference(@NotNull SqlReferenceExpression r, @NotNull Consumer<LookupElement> resultSet, PsiElement context) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forSqlReference"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forSqlReference"));
        }
        SqlIdentifier identifier = r.getIdentifier();
        String prefix = identifier == null ? null : identifier.getNamePrefix();
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)r).getDatabaseDialect();
        String name = r.getName();
        LookupElementBuilder builder = prefix != null ? LookupElementBuilder.create((String)(prefix + name)).withPresentableText(prefix + dialect.quoteIdentifier(name, false, false)).withInsertHandler(SqlCompletionUtil.createPrefixHandler(name, prefix, dialect)) : LookupElementBuilder.create((String)name);
        if (SqlCompletionUtil.canResolveConflict(context)) {
            builder = builder.withInsertHandler(SqlCompletionUtil.createQualifierHandler(dialect, (InsertHandler<LookupElement>)builder.getInsertHandler()));
        }
        resultSet.consume((Object)builder);
        return true;
    }

    @NotNull
    public static InsertHandler<LookupElement> createQualifierHandler(final DatabaseDialectEx dialect, final InsertHandler<LookupElement> handler) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                SqlIdentifier identifier;
                List<String> forcedContext;
                if (handler != null) {
                    handler.handleInsert(context, item);
                }
                context.commitDocument();
                PsiElement element = CompletionUtil.getTargetElement((LookupElement)item);
                DasObject obj = (DasObject)ObjectUtils.tryCast((Object)element, DasObject.class);
                if (obj == null) {
                    return;
                }
                SqlQualifiedResolveResult resolveResult = (SqlQualifiedResolveResult)((Object)ObjectUtils.tryCast((Object)item.getObject(), SqlQualifiedResolveResult.class));
                List<String> list = forcedContext = resolveResult == null ? null : resolveResult.getQualification();
                if (forcedContext == null) {
                    forcedContext = this.qualification(obj.getDbParent());
                }
                int offset = context.getTailOffset();
                SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(offset > 1 ? offset - 1 : offset), SqlReferenceExpression.class, (boolean)false);
                SqlIdentifier sqlIdentifier = identifier = ref == null ? null : ref.getIdentifier();
                if (identifier == null || ref.getQualifierExpression() != null || ref.getParent() instanceof SqlReferenceExpression) {
                    return;
                }
                Condition filter = element instanceof SqlElement ? rr -> rr.getElement() instanceof SqlElement : rr -> !(rr.getElement() instanceof SqlElement);
                JBIterable resolveResults = JBIterable.of((Object[])ref.multiResolve(false)).filter(filter);
                if (resolveResults.size() < 2) {
                    return;
                }
                List<List<String>> qualifiers = this.getQualifier((Iterable<ResolveResult>)resolveResults, forcedContext, obj);
                if (qualifiers.isEmpty()) {
                    return;
                }
                SqlIntentionUtil.qualifyReference(qualifiers, identifier, context.getEditor());
            }

            @NotNull
            private List<List<String>> getQualifier(@NotNull Iterable<ResolveResult> results, @Nullable Iterable<String> forcedContext, @NotNull DasObject obj) {
                if (results == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/sql/psi/impl/SqlCompletionUtil$5", "getQualifier"));
                }
                if (obj == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/psi/impl/SqlCompletionUtil$5", "getQualifier"));
                }
                LinkedHashSet qualifiers = ContainerUtil.newLinkedHashSet();
                HashSet all = ContainerUtil.newHashSet();
                for (ResolveResult result : results) {
                    SqlResolveResult res = (SqlResolveResult)ObjectUtils.tryCast((Object)result, SqlResolveResult.class);
                    PsiElement psi = res == null ? null : res.getQualifier();
                    DasObject qual = (DasObject)ObjectUtils.tryCast((Object)psi, DasObject.class);
                    DasObject elem = (DasObject)ObjectUtils.tryCast((Object)result.getElement(), DasObject.class);
                    if (psi != null && qual == null || elem == null) continue;
                    if (qual == null) {
                        qual = elem.getDbParent();
                    }
                    if (Comparing.equal((String)elem.getName(), (String)obj.getName()) && this.eq((Iterable<String>)this.qualification(qual), forcedContext)) {
                        qualifiers.add(qual);
                    }
                    all.add(qual);
                }
                List qualPaths = ContainerUtil.newSmartList();
                for (DasObject qualifier : qualifiers) {
                    List list = ContainerUtil.newSmartList();
                    all.remove(qualifier);
                    this.appendQualification(qualifier, all, list, dialect);
                    all.add(qualifier);
                    Collections.reverse(list);
                    if (list.isEmpty()) continue;
                    qualPaths.add(list);
                }
                List list = qualPaths;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil$5", "getQualifier"));
                }
                return list;
            }

            @Nullable
            private JBIterable<String> qualification(@Nullable DasObject obj) {
                return obj == null ? null : DasUtil.dasParents((DasObject)obj).transform(DasUtil.TO_NAME);
            }

            private boolean eq(@Nullable Iterable<String> it1, @Nullable Iterable<String> it2) {
                if (it1 == null || it2 == null) {
                    return it1 == it2;
                }
                Iterator<String> i1 = it1.iterator();
                Iterator<String> i2 = it2.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    if (Comparing.equal((String)i1.next(), (String)i2.next())) continue;
                    return false;
                }
                return i1.hasNext() == i2.hasNext();
            }

            private void appendQualification(@Nullable DasObject qualifier, @NotNull Set<DasObject> other, @NotNull List<String> path, @NotNull CasingProvider casingProvider) {
                if (other == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/sql/psi/impl/SqlCompletionUtil$5", "appendQualification"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/psi/impl/SqlCompletionUtil$5", "appendQualification"));
                }
                if (casingProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/psi/impl/SqlCompletionUtil$5", "appendQualification"));
                }
                if (qualifier == null || qualifier.getKind() == ObjectKind.NONE || other.isEmpty() || StringUtil.isEmpty((String)qualifier.getName())) {
                    return;
                }
                String name = qualifier.getName();
                path.add(name);
                Set filtered = JBIterable.from(other).filter(DasUtil.byName((String)name, (CasingProvider)casingProvider)).transform(DasObject::getDbParent).filter(Conditions.notNull()).toSet();
                int sz = path.size();
                this.appendQualification(qualifier.getDbParent(), filtered, path, casingProvider);
                if (sz == path.size() && filtered.size() == other.size()) {
                    path.remove(path.size() - 1);
                }
            }
        };
        if (insertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createQualifierHandler"));
        }
        return insertHandler;
    }

    @NotNull
    public static InsertHandler<LookupElement> createPrefixHandler(final String name, final String prefix, final DatabaseDialect dialect) {
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                int start = context.getStartOffset();
                int end = context.getTailOffset();
                context.getDocument().replaceString(start, end, (CharSequence)(prefix + dialect.quoteIdentifier(name, false, false)));
            }
        };
        if (insertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createPrefixHandler"));
        }
        return insertHandler;
    }

    private static boolean canResolveConflict(@Nullable PsiElement element) {
        return !(element instanceof SqlReferenceExpression) || ((SqlReferenceExpression)element).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE && ((SqlReferenceExpression)element).getReferenceElementType() != SqlCompositeElementTypes.SQL_SHORT_REFERENCE;
    }

    public static boolean forSqlFunction(@NotNull SqlLanguageDialectEx dialect, @NotNull SqlFunctionDefinition f, @NotNull Consumer<LookupElement> resultSet) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forSqlFunction"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forSqlFunction"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forSqlFunction"));
        }
        SqlFunctionDefinition.Prototype[] prototypes = f.getPrototypes();
        if (prototypes.length == 0) {
            return false;
        }
        for (SqlFunctionDefinition.Prototype prototype : prototypes) {
            resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)1.0));
        }
        return true;
    }

    public static boolean forAlias(@NotNull SqlAsExpression t, @NotNull Consumer<LookupElement> resultSet, @NotNull DatabaseDialect databaseDialect) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forAlias"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forAlias"));
        }
        if (databaseDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseDialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forAlias"));
        }
        String name = SqlCompletionUtil.calcName((PsiNamedElement)t, databaseDialect);
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)LookupElementBuilder.create((Object)t, (String)name).withInsertHandler(SqlCompletionUtil.handler((PsiNamedElement)t, databaseDialect, false)), (int)1), (double)10.0));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forPsiNamedElement(@NotNull PsiNamedElement o, @Nullable PsiElement forcedContext, @NotNull Consumer<LookupElement> resultSet, boolean addDot, double forcePriority, @NotNull DatabaseDialect databaseDialect, PsiElement psiElement) {
        void element;
        DasObject context;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forPsiNamedElement"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forPsiNamedElement"));
        }
        if (databaseDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseDialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forPsiNamedElement"));
        }
        String name = SqlCompletionUtil.calcName(o, databaseDialect);
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        Icon icon = o instanceof PsiPresentableMetaData ? ((PsiPresentableMetaData)o).getIcon() : o.getIcon(0);
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)((Object)new SqlQualifiedResolveResult(forcedContext, (PsiElement)o)), (String)name).withTypeText(SqlCompletionUtil.typeText(o)).withInsertHandler(SqlCompletionUtil.handler(o, databaseDialect, addDot)).withIcon(icon);
        String prefix = SqlCompletionUtil.getPrefix(o);
        if (prefix != null) {
            lookup = lookup.withPresentableText(prefix + databaseDialect.quoteIdentifier(o.getName(), false, false));
        }
        if (name.contains(" ")) {
            lookup = lookup.withLookupString(name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_")).withLookupString(name.replaceAll(" ", "_"));
        }
        DasObject dasObject = context = forcedContext == null && o instanceof DasObject ? ((DasObject)o).getDbParent() : (DasObject)ObjectUtils.tryCast((Object)forcedContext, DasObject.class);
        if (context != null) {
            String qname;
            String string = qname = context instanceof DbDataSource ? null : QNameUtil.getQualifiedName(context);
            if (StringUtil.isNotEmpty((String)qname)) {
                lookup = lookup.withTailText(" (" + qname + ")", true);
            }
        }
        double priority = o instanceof DbElement ? 5.0 : 10.0;
        for (DasObject cur = (DasObject)ObjectUtils.tryCast((Object)o, DasObject.class); cur != null; cur = cur.getDbParent()) {
            priority += 0.1;
        }
        if (SqlCompletionUtil.canResolveConflict((PsiElement)element)) {
            lookup = lookup.withInsertHandler(SqlCompletionUtil.createQualifierHandler((DatabaseDialectEx)databaseDialect, (InsertHandler<LookupElement>)lookup.getInsertHandler()));
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)Math.max(forcePriority, priority)));
        return true;
    }

    @Nullable
    public static String calcName(@NotNull PsiNamedElement o, @NotNull DatabaseDialect databaseDialect) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "calcName"));
        }
        if (databaseDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseDialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "calcName"));
        }
        String roughName = SqlCompletionUtil.roughName(o);
        return StringUtil.isEmpty((String)roughName) ? null : SqlCompletionUtil.getIdentifierMode(o.getProject(), o, databaseDialect).apply(roughName);
    }

    @Nullable
    public static InsertHandler<LookupElement> handler(PsiNamedElement t, DatabaseDialect databaseDialect, boolean addDot) {
        String prefix;
        SqlPrefixedElement prefixed = SqlCompletionUtil.getPrefixed(t);
        String string = prefix = prefixed == null ? null : prefixed.getNamePrefix();
        if (prefix != null) {
            return SqlCompletionUtil.createPrefixHandler(t.getName(), prefix, databaseDialect);
        }
        return SqlImplUtil.hasPlainIdentifier(t, databaseDialect) ? (addDot ? DOT_INSERT_HANDLER : null) : (addDot ? QUOT_DOT_INSERT_HANDLER : QUOT_INSERT_HANDLER);
    }

    @NotNull
    public static Case getIdentifierMode(@NotNull Project project, @NotNull Object o, @NotNull DatabaseDialect dialect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getIdentifierMode"));
        }
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getIdentifierMode"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getIdentifierMode"));
        }
        Case case_ = SqlImplUtil.hasPlainIdentifier(o, dialect) ? SqlCompletionUtil.getIdentifierCase(project) : SqlCompletionUtil.getQuotedIdentifierCase(project);
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getIdentifierMode"));
        }
        return case_;
    }

    @Nullable
    public static String roughName(@NotNull PsiNamedElement o) {
        String origin;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "roughName"));
        }
        if (o instanceof SqlFileImpl.FakeDefinition && (origin = ((SqlFileImpl.FakeDefinition)o).getOriginalName()) != null) {
            return origin;
        }
        String prefix = SqlCompletionUtil.getPrefix(o);
        return prefix == null ? o.getName() : prefix + o.getName();
    }

    @Nullable
    public static String typeText(@NotNull PsiNamedElement t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/impl/SqlCompletionUtil", "typeText"));
        }
        if (t instanceof DasTypedObject) {
            return JdbcUtil.getJdbcTypeName((DataType)((DasTypedObject)t).getDataType());
        }
        if (t instanceof SqlFileImpl.FakeDefinition) {
            return ((SqlFileImpl.FakeDefinition)t).getTypeName();
        }
        if (t instanceof DbElement) {
            return ((DbElement)t).getDataSource().getName();
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)t);
        return file == null ? t.getName() : EditorTabbedContainer.calcTabTitle((Project)t.getProject(), (VirtualFile)file);
    }

    @Nullable
    public static SqlPrefixedElement getPrefixed(@NotNull PsiNamedElement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getPrefixed"));
        }
        return (SqlPrefixedElement)ObjectUtils.tryCast((Object)(o instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)o).getNameIdentifier() : o), SqlPrefixedElement.class);
    }

    @Nullable
    public static String getPrefix(@NotNull PsiNamedElement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getPrefix"));
        }
        SqlPrefixedElement prefixed = SqlCompletionUtil.getPrefixed(o);
        return prefixed == null ? null : prefixed.getNamePrefix();
    }

    public static boolean forProcedureInfo(@NotNull PsiNamedElement o, @NotNull Consumer<LookupElement> resultSet, @NotNull DatabaseDialectEx databaseDialect, @Nullable PsiElement context) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forProcedureInfo"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forProcedureInfo"));
        }
        if (databaseDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseDialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "forProcedureInfo"));
        }
        LookupElement procedureLookup = PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(o.getProject(), (DasRoutine)o, databaseDialect, context), (double)0.0);
        resultSet.consume((Object)procedureLookup);
        return true;
    }

    @NotNull
    public static Case getIdentifierCase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getIdentifierCase"));
        }
        SqlCodeStyleSettings settings = SqlCompletionUtil.settings(project);
        Case case_ = SqlCodeStyleSettings.getCaseMode((int)(settings == null ? 2 : settings.IDENTIFIER_CASE));
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getIdentifierCase"));
        }
        return case_;
    }

    @NotNull
    public static Case getQuotedIdentifierCase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getQuotedIdentifierCase"));
        }
        SqlCodeStyleSettings settings = SqlCompletionUtil.settings(project);
        Case case_ = SqlCodeStyleSettings.getCaseMode((int)(settings == null ? 2 : settings.QUOTED_IDENTIFIER_CASE));
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "getQuotedIdentifierCase"));
        }
        return case_;
    }

    @Nullable
    public static SqlCodeStyleSettings settings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlCompletionUtil", "settings"));
        }
        return (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
    }

    @NotNull
    public static LookupElement createEntityLookupItem(@NotNull Project project, @NotNull String entityName, @NotNull SqlType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createEntityLookupItem"));
        }
        if (entityName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityName", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createEntityLookupItem"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createEntityLookupItem"));
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)SqlCompletionUtil.getIdentifierCase(project).apply(entityName)).bold().withTypeText(!(type instanceof SqlTableType) ? type.getDisplayName() : null);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createEntityLookupItem"));
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElementBuilder createLookupItem(@NotNull String str, boolean boldness, boolean caseSensitivity, @Nullable InsertHandler<LookupElement> handler, String ... aliases) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)str).withBoldness(boldness).withCaseSensitivity(caseSensitivity).withInsertHandler(handler);
        for (String alias : aliases) {
            element = element.withLookupString(alias);
        }
        LookupElementBuilder lookupElementBuilder = element;
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        return lookupElementBuilder;
    }

    public static boolean isJoinUsingColumn(@Nullable PsiElement element) {
        SqlReferenceList usingList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceList.class);
        return usingList != null && usingList.getParent() instanceof SqlUsingClause && usingList.getParent().getParent() instanceof SqlJoinExpression;
    }

    public static boolean isDropTarget(@Nullable PsiElement element) {
        SqlDropStatement drop = (SqlDropStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlDropStatement.class);
        return drop != null && PsiTreeUtil.isAncestor((PsiElement)drop.getTargetExpression(), (PsiElement)element, (boolean)false);
    }

    public static LookupElement createLookupItem(@NotNull Project project, @NotNull DasRoutine def, final @NotNull DatabaseDialectEx dialect, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        if (def == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "def", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)def);
        List retArg = ContainerUtil.createMaybeSingletonList((Object)def.getReturnArgument());
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder identifier(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlCompletionUtil$7", "identifier"));
                }
                DdlBuilder ddlBuilder = this.plain(name);
                if (ddlBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil$7", "identifier"));
                }
                return ddlBuilder;
            }
        }.withDialect(dialect).applyCodeStyle(project);
        builder.identifier(def.getName());
        boolean routineCall = !SqlCompletionUtil.isDropTarget(context);
        boolean supportsOverloads = dialect.getFamilyId().isPostgres();
        boolean noParensCall = dialect.getFamilyId().isMicrosoft() && PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectClause.class) == null;
        final boolean useSpaces = noParensCall || !routineCall && !supportsOverloads;
        String presentableText = SqlCompletionUtil.addParametersPresentableText(builder, (Iterable<? extends DasArgument>)parameters, false, useSpaces).getStatement();
        String typeText = SqlCompletionUtil.addParametersPresentableText(builder.clear(), retArg, true, useSpaces).getStatement();
        final boolean noParams = Iterables.isEmpty((Iterable)parameters) || !routineCall && !supportsOverloads;
        return LookupElementBuilder.create((Object)def, (String)builder.clear().identifier(def.getName()).getStatement()).withIcon(DatabaseIcons.Function).withPresentableText(presentableText).withTypeText(typeText).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlCompletionUtil$8", "handleInsert"));
                }
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/sql/psi/impl/SqlCompletionUtil$8", "handleInsert"));
                }
                if (!SqlImplUtil.hasPlainIdentifier(item.getPsiElement(), dialect)) {
                    QUOT_INSERT_HANDLER.handleInsert(context, item);
                }
                this.handler().handleInsert(context, item);
            }

            @NotNull
            public InsertHandler<LookupElement> handler() {
                Object object = useSpaces ? (noParams ? DUMMY_HANDLER : AddSpaceInsertHandler.INSTANCE) : (noParams ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS);
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil$8", "handler"));
                }
                return object;
            }
        });
    }

    @NotNull
    public static DdlBuilder addParametersPresentableText(@NotNull DdlBuilder builder, @NotNull Iterable<? extends DasArgument> parameters, boolean result, boolean useSpaces) {
        boolean parentheses;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addParametersPresentableText"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addParametersPresentableText"));
        }
        boolean bl = parentheses = !result || Iterables.size(parameters) > 1;
        if (parentheses) {
            builder.symbol(useSpaces ? " " : "(");
        }
        boolean first = true;
        for (DasArgument dasArgument : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            if (!result) {
                builder.identifier((String)ObjectUtils.notNull((Object)dasArgument.getName(), (Object)"")).symbol(":");
            }
            builder.type((DasTypedObject)dasArgument);
        }
        if (parentheses) {
            builder.symbol(useSpaces ? "" : ")");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "addParametersPresentableText"));
        }
        return ddlBuilder;
    }

    public static LookupElement createLookupItem(final @NotNull SqlFunctionDefinition.Prototype prototype, @NotNull SqlLanguageDialect dialect) {
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createLookupItem"));
        }
        LookupElementBuilder element = LookupElementBuilder.create((Object)prototype, (String)prototype.getFunction().getName()).withCaseSensitivity(false).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlCompletionUtil$9", "renderElement"));
                }
                if (presentation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/sql/psi/impl/SqlCompletionUtil$9", "renderElement"));
                }
                presentation.setIcon(DatabaseIcons.Function);
                presentation.setItemText(element.getLookupString());
                String params2 = new SqlFunctionDefinition.ParameterBlock(-1, prototype.getBlockType(), prototype.getParams(), false).toString();
                presentation.appendTailText(params2, true);
                presentation.setTypeText(prototype.getReturnType().getDisplayName());
            }
        });
        if (!((SqlLanguageDialectEx)dialect).canBeCalledWithoutParens(prototype)) {
            element = element.withInsertHandler((InsertHandler)(prototype.getParams().length == 0 ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS));
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String str, @Nullable InsertHandler<LookupElement> handler, double correction, String ... stringArray) {
        void aliases;
        if (keywordCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordCase", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createKeywordLookupElement"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createKeywordLookupElement"));
        }
        if (stringArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createKeywordLookupElement"));
        }
        boolean caseSensitive = keywordCase == Case.UPPER || keywordCase == Case.LOWER;
        LookupElementBuilder element = SqlCompletionUtil.createLookupItem(keywordCase.apply(str), true, caseSensitive, handler, (String[])aliases).withLookupString(str.toLowerCase(Locale.ENGLISH)).withLookupString(str.toUpperCase(Locale.ENGLISH));
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)(5.0 + correction));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCompletionUtil", "createKeywordLookupElement"));
        }
        return lookupElement;
    }

    private static class SqlQualifiedResolveResult
    extends PsiElementResolveResult {
        private final List<String> myQualification;

        public SqlQualifiedResolveResult(@Nullable PsiElement qualifier, @NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlCompletionUtil$SqlQualifiedResolveResult", "<init>"));
            }
            super(element);
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)qualifier, DasObject.class);
            this.myQualification = qualifier == null ? null : (object == null ? Collections.emptyList() : DasUtil.dasParents((DasObject)object).transform(DasUtil.TO_NAME).toList());
        }

        @Nullable
        public List<String> getQualification() {
            return this.myQualification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SqlQualifiedResolveResult result = (SqlQualifiedResolveResult)((Object)o);
            return !(this.myQualification != null ? !this.myQualification.equals(result.myQualification) : result.myQualification != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myQualification != null ? this.myQualification.hashCode() : 0);
            return result;
        }
    }
}

