/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAsExpressionImpl
extends SqlDefinitionImpl
implements SqlAsExpression,
SqlLocalDefinition {
    public SqlAsExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public SqlType getSqlType() {
        SqlExpression expression = this.getExpression();
        SqlType type = expression.getSqlType();
        List<SqlColumnAliasDefinition> aliases = this.getColumnAliasList();
        if (aliases.isEmpty()) {
            if (type instanceof SqlTableType) {
                if (this.getParent() instanceof SqlSelectClause) {
                    SqlTableType tableType = (SqlTableType)type;
                    SqlType sqlType = tableType.getColumnCount() == 1 ? tableType.getColumnType(0) : type;
                    if (sqlType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getSqlType"));
                    }
                    return sqlType;
                }
                SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(type, (SqlElement)expression, (PsiElement)this).alias(this.getName(), (PsiElement)this, aliases);
                if (sqlTableType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getSqlType"));
                }
                return sqlTableType;
            }
            SqlType sqlType = type;
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getSqlType"));
            }
            return sqlType;
        }
        SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(type, (SqlElement)expression, (PsiElement)this).alias(this.getName(), (PsiElement)this, aliases);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getSqlType"));
        }
        return sqlTableType;
    }

    @Nullable
    public PsiElement getDefinitionScope() {
        PsiElement context = this.getContext();
        if (context instanceof SqlDeclareStatement) {
            return this.getTopmostBlockStatement();
        }
        return PsiTreeUtil.getContextOfType((PsiElement)this, SqlStatement.class, (boolean)true);
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement scope = this.getDefinitionScope();
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(scope == null ? this.getContainingFile() : scope));
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    protected SqlBlockStatementImpl getTopmostBlockStatement() {
        SqlBlockStatementImpl next;
        SqlBlockStatementImpl answer = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{SqlBlockStatementImpl.class});
        while ((next = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)answer, (Class[])new Class[]{SqlBlockStatementImpl.class})) != null) {
            answer = next;
        }
        return answer;
    }

    @NotNull
    public List<SqlColumnAliasDefinition> getColumnAliasList() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlColumnAliasDefinition.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getColumnAliasList"));
        }
        return list;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlAsExpression((SqlAsExpression)this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        SqlIdentifier sqlIdentifier = this.getNameElement();
        if (sqlIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getNavigationElement"));
        }
        return sqlIdentifier;
    }

    @NotNull
    public SqlIdentifier getNameElement() {
        SqlIdentifier sqlIdentifier = (SqlIdentifier)this.findNotNullChildByClass(SqlIdentifier.class);
        if (sqlIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getNameElement"));
        }
        return sqlIdentifier;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public PsiReference getReference() {
        SqlIdentifier nameElement = this.getNameElement();
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)this);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        PsiReferenceBase psiReferenceBase = ref;
        if (psiReferenceBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getReference"));
        }
        return psiReferenceBase;
    }

    @NotNull
    public SqlExpression getExpression() {
        List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlExpression.class);
        if (expressions.isEmpty()) {
            SqlDialectImplUtil.LOG.error(String.format("%s: no alias in [%s]", SqlImplUtil.getSqlDialectSafe((PsiElement)this).getID(), this.getParent().getText()));
        }
        SqlExpression sqlExpression = (SqlExpression)expressions.get(0);
        if (sqlExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "getExpression"));
        }
        return sqlExpression;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Variable;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        SqlType type;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlAsExpressionImpl", "processDeclarations"));
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this, (PsiElement)place, (boolean)true)) {
            if (place.getParent() instanceof SqlReferenceList && this.getLastChild() == place.getParent()) {
                return processor.execute(place, state);
            }
            return this.getNode().getElementType() != SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION || processor.execute((PsiElement)this, state);
        }
        SqlExpression asExpression = this.getExpression();
        return !(asExpression instanceof SqlReferenceExpression && this.getColumnAliasList().isEmpty() ? asExpression != lastParent && !SqlImplUtil.processQualifier((SqlReferenceExpression)asExpression, processor, state, place) : (type = this.getSqlType()) instanceof SqlTableType && !SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state));
    }
}

