/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SqlSuppressInspectionFix
extends SuppressByCommentFix {
    public SqlSuppressInspectionFix(@NotNull String id, @NotNull Class<? extends SqlElement> containerClass) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "<init>"));
        }
        if (containerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerClass", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "<init>"));
        }
        super(id, containerClass);
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "createSuppression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "createSuppression"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "createSuppression"));
        }
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
        String text = SqlSuppressInspectionFix.tag(this.myID, false);
        PsiComment comment = parserFacade.createLineOrBlockCommentFromText(element.getContainingFile().getLanguage(), text);
        PsiElement where = container.getParent().addBefore((PsiElement)comment, container);
        PsiElement spaceFromText = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
        where.getParent().addAfter(spaceFromText, where);
    }

    @NotNull
    public static String tag(@NotNull String id, boolean forFile) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "tag"));
        }
        String string = "noinspection " + id + (forFile ? "ForFile" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/suppression/SqlSuppressInspectionFix", "tag"));
        }
        return string;
    }
}

