/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNoDataSourceInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        if ("SqlNoDataSourceInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlNoDataSourceInspection", "getShortName"));
        }
        return "SqlNoDataSourceInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/SqlNoDataSourceInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlNoDataSourceInspection", "checkFile"));
        }
        if (!isOnTheFly || !(file instanceof SqlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        if (topLevelFile.getVirtualFile() instanceof LightVirtualFile) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!DbPsiFacade.getInstance((Project)manager.getProject()).getDataSources().isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        boolean injectedFile = topLevelFile != file;
        MyQuickFix setupFix = new MyQuickFix();
        LocalQuickFix[] quickFixes = new LocalQuickFix[]{setupFix};
        AnAction action = ActionManager.getInstance().getAction("ShowIntentionActions");
        String messageTail = injectedFile ? " Disable this inspection via problem menu (" + KeymapUtil.getFirstKeyboardShortcutText((AnAction)action) + ")." : "";
        String message = "No data sources are configured to run this SQL and provide advanced code assistance." + messageTail;
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file, message, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{descriptor};
    }

    private static class MyQuickFix
    extends IntentionAndQuickFixAction {
        private MyQuickFix() {
        }

        @NotNull
        public String getName() {
            if ("Configure data source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlNoDataSourceInspection$MyQuickFix", "getName"));
            }
            return "Configure data source";
        }

        @NotNull
        public String getFamilyName() {
            if ("Configure data source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlNoDataSourceInspection$MyQuickFix", "getFamilyName"));
            }
            return "Configure data source";
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlNoDataSourceInspection$MyQuickFix", "applyFix"));
            }
            DataSourceManagerDialog.showDialog(project, null);
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

