/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlAutoIncrementDuplicateInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlAutoIncrementDuplicateInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlAutoIncrementDuplicateInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlAutoIncrementDuplicateInspection", "createAnnotationVisitor"));
        }
        DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        if (!(familyId.isMysql() || familyId.isTransactSql() || familyId.isDb2())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o) {
                boolean autoIncrementFound = false;
                for (SqlColumnDefinition column : o.getDeclaredColumns()) {
                    ASTNode genClause;
                    SqlColumnDefinition anchor;
                    boolean generated = SqlImplUtil.isAutoVal(column);
                    if (!generated || (anchor = (genClause = column.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE)) == null ? column : genClause.getPsi()) == null) continue;
                    if (autoIncrementFound) {
                        this.addWarning((PsiElement)anchor);
                    }
                    boolean autoInc = genClause == null || genClause.getFirstChildNode() == genClause.getLastChildNode() || genClause.findChildByType((IElementType)SqlCommonKeywords.SQL_IDENTITY) != null;
                    autoIncrementFound |= autoInc;
                }
            }

            private void addWarning(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlAutoIncrementDuplicateInspection$1", "addWarning"));
                }
                this.addDescriptor(this.myManager.createProblemDescriptor(element, "Only one auto increment column and it must be defined as a key", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }
        };
    }
}

