/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeBasedInjection
extends BaseInjection {
    public static final Pattern INVALID_PATTERN = Pattern.compile("");
    private Pattern myPattern = INVALID_PATTERN;
    private boolean myEnabled = false;

    public SqlTypeBasedInjection() {
        super("sql");
    }

    public SqlTypeBasedInjection copyFrom(@NotNull BaseInjection other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/sql/injection/SqlTypeBasedInjection", "copyFrom"));
        }
        super.copyFrom(other);
        this.myPattern = ((SqlTypeBasedInjection)other).myPattern;
        this.myEnabled = ((SqlTypeBasedInjection)other).myEnabled;
        return this;
    }

    public void setPattern(@NotNull Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/injection/SqlTypeBasedInjection", "setPattern"));
        }
        this.myPattern = p;
    }

    @NotNull
    public Pattern getPattern() {
        Pattern pattern = this.myPattern;
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjection", "getPattern"));
        }
        return pattern;
    }

    protected void readExternalImpl(Element e) {
        super.readExternalImpl(e);
        String pattern = e.getAttributeValue("pattern");
        if (pattern != null) {
            this.myPattern = PatternUtil.compileSafe((String)pattern, (Pattern)INVALID_PATTERN);
        }
        this.myEnabled = Boolean.parseBoolean(e.getAttributeValue("enabled"));
    }

    protected void writeExternalImpl(Element e) {
        super.writeExternalImpl(e);
        if (StringUtil.isNotEmpty((String)this.myPattern.pattern())) {
            e.setAttribute("pattern", this.myPattern.pattern());
        }
        if (this.myEnabled) {
            e.setAttribute("enabled", Boolean.toString(true));
        }
    }

    public SqlTypeBasedInjection copy() {
        return new SqlTypeBasedInjection().copyFrom(this);
    }

    public boolean sameLanguageParameters(BaseInjection that) {
        if (!super.sameLanguageParameters(that)) {
            return false;
        }
        return that instanceof SqlTypeBasedInjection && this.myPattern.pattern().equals(((SqlTypeBasedInjection)that).myPattern.pattern()) && this.myEnabled == ((SqlTypeBasedInjection)that).myEnabled;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myPattern.pattern().hashCode();
        result = 31 * result + Boolean.hashCode(this.myEnabled);
        return result;
    }

    public void setPlaceEnabled(@Nullable String text, boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isEnabled() {
        return StringUtil.isNotEmpty((String)this.myPattern.pattern()) && this.myEnabled;
    }
}

