/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.injected.editor.VirtualFileWindowImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.highlighting.ChangeSqlDialectIntentionFix;
import com.intellij.sql.psi.SqlElement;
import org.jetbrains.annotations.NotNull;

public class SqlErrorQuickFixProvider
implements ErrorQuickFixProvider {
    public void registerErrorQuickFix(@NotNull PsiErrorElement errorElement, @NotNull HighlightInfo highlightInfo) {
        if (errorElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "com/intellij/sql/highlighting/SqlErrorQuickFixProvider", "registerErrorQuickFix"));
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/sql/highlighting/SqlErrorQuickFixProvider", "registerErrorQuickFix"));
        }
        PsiElement parent = errorElement.getParent();
        if (!(parent instanceof SqlElement)) {
            return;
        }
        VirtualFile virtualFile = parent.getContainingFile().getVirtualFile();
        if (virtualFile instanceof VirtualFileWindowImpl && ((VirtualFileWindowImpl)virtualFile).getLanguage() instanceof SqlLanguageDialect) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)errorElement.getProject()).getInjectionHost((PsiElement)errorElement);
        PsiFile containingFile = (host != null ? host : errorElement).getContainingFile();
        if (!containingFile.getViewProvider().isPhysical()) {
            return;
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new ChangeSqlDialectIntentionFix());
    }
}

