/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.generation.surroundWith;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.generation.surroundWith.SqlFunctionSurrounder;
import com.intellij.sql.generation.surroundWith.SqlParenthesisSurrounder;
import com.intellij.sql.generation.surroundWith.SqlQuoteSurrounder;
import org.jetbrains.annotations.NotNull;

public class SqlSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new SqlParenthesisSurrounder(), new SqlFunctionSurrounder(), new SqlQuoteSurrounder()};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement first = file.findElementAt(startOffset);
        PsiElement last = file.findElementAt(endOffset - 1);
        if (last == null || first == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/surroundWith/SqlSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = new PsiElement[]{PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)last)};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/surroundWith/SqlSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/generation/surroundWith/SqlSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }
}

