/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import org.jetbrains.annotations.NotNull;

public class SqlEnterHandlerImpl
extends EnterHandlerDelegateAdapter {
    private final SqlCloseBlockProcessor[] myProcessors;

    public SqlEnterHandlerImpl(SqlCloseBlockProcessor ... processors) {
        if (processors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processors", "com/intellij/sql/editor/SqlEnterHandlerImpl", "<init>"));
        }
        this.myProcessors = processors;
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlEnterHandlerImpl", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlEnterHandlerImpl", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/sql/editor/SqlEnterHandlerImpl", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/sql/editor/SqlEnterHandlerImpl", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/editor/SqlEnterHandlerImpl", "preprocessEnter"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!SqlEnterHandlerImpl.shouldHandle(editor, dataContext)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement element = SqlEnterHandlerImpl.getWorkingElement(file, editor);
        if (element == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        for (SqlCloseBlockProcessor processor : this.myProcessors) {
            if (!processor.process(element, file, editor, dataContext)) continue;
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static PsiElement getWorkingElement(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/editor/SqlEnterHandlerImpl", "getWorkingElement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/editor/SqlEnterHandlerImpl", "getWorkingElement"));
        }
        int caret = editor.getCaretModel().getOffset();
        if (caret == 0) {
            return null;
        }
        PsiElement elementAt = file.findElementAt(caret - 1);
        if (elementAt != null && StringUtil.isEmptyOrSpaces((String)elementAt.getText())) {
            elementAt = PsiTreeUtil.prevVisibleLeaf((PsiElement)elementAt);
        }
        return elementAt;
    }

    private static boolean shouldHandle(Editor editor, DataContext dataContext) {
        if (editor.isViewer()) {
            return false;
        }
        Document document = editor.getDocument();
        return document.isWritable();
    }
}

