/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlInheritedTableDefinition;
import com.intellij.sql.psi.SqlLikeTableClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlCreateTableStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PgCreateTableStatementImpl
extends SqlCreateTableStatementImpl
implements SqlInheritedTableDefinition {
    private static final PairFunction<PsiColumn, PsiColumn, Boolean> MERGE_CHECK = SqlImplUtil::hasSameTypes;
    private static IElementType[] INHERITANCE_METHODS = new IElementType[]{PgTypes.PG_LIKE_TABLE_CLAUSE, PgTypes.PG_INHERITS_TABLE_CLAUSE};

    public PgCreateTableStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "<init>"));
        }
        super(node);
    }

    public PgCreateTableStatementImpl(SqlTableStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    protected List<PsiColumn> calcColumns() {
        boolean sensitive = this.isColumnsCaseSensitive();
        List<PsiColumn> inherited = this.getAdditionalColumnsImpl(PgTypes.PG_INHERITS_TABLE_CLAUSE);
        List<PsiColumn> res = this.getAdditionalColumnsImpl(PgTypes.PG_LIKE_TABLE_CLAUSE);
        SqlImplUtil.mergeColumnListInto(res, inherited, sensitive, MERGE_CHECK);
        res.addAll(SqlImplUtil.processColumnList(this.getDeclaredColumns(), inherited, sensitive, MERGE_CHECK, true));
        List list = ContainerUtil.concat(this.getQueryColumns(), res);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "calcColumns"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiColumn> getAdditionalColumns() {
        List<PsiColumn> list = SqlImplUtil.mergeColumnListInto(this.getAdditionalColumnsImpl(PgTypes.PG_LIKE_TABLE_CLAUSE), this.getAdditionalColumnsImpl(PgTypes.PG_INHERITS_TABLE_CLAUSE), this.isColumnsCaseSensitive(), MERGE_CHECK);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumns"));
        }
        return list;
    }

    @NotNull
    public List<PsiColumn> getAdditionalColumnsImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumnsImpl"));
        }
        boolean sensitive = this.isColumnsCaseSensitive();
        List<SqlReferenceExpression> ancestors = this.getAncestors(elementType);
        ArrayList plainColumns = ContainerUtil.newArrayList();
        if (ancestors.isEmpty()) {
            ArrayList arrayList = plainColumns;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumnsImpl"));
            }
            return arrayList;
        }
        for (SqlReferenceExpression ancestor : ancestors) {
            PsiElement element = ancestor.resolve();
            if (!(element instanceof PsiTable)) continue;
            SqlTableType tableType = SqlTableTypeBase.createType((PsiTable)element, (PsiElement)this);
            List inherited = ContainerUtil.findAll(((TableBasedSqlTableTypeImpl)tableType).getColumns(), SqlColumnDefinition.class);
            if (elementType == PgTypes.PG_INHERITS_TABLE_CLAUSE) {
                SqlImplUtil.mergeColumnListInto(plainColumns, inherited, sensitive, MERGE_CHECK);
                continue;
            }
            plainColumns.addAll(inherited);
        }
        ArrayList arrayList = plainColumns;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumnsImpl"));
        }
        return arrayList;
    }

    @NotNull
    public Object[] getInheritanceMethods() {
        if (INHERITANCE_METHODS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getInheritanceMethods"));
        }
        return INHERITANCE_METHODS;
    }

    @NotNull
    public List<SqlReferenceExpression> getAncestors(@NotNull Object methodKey) {
        if (methodKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKey", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAncestors"));
        }
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            List<SqlReferenceExpression> list = stub.getAncestorRefs(ArrayUtil.indexOf((Object[])INHERITANCE_METHODS, (Object)methodKey));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAncestors"));
            }
            return list;
        }
        ArrayList refs = ContainerUtil.newArrayList();
        for (SqlLikeTableClause clause : (SqlLikeTableClause[])this.findChildrenByClass(SqlLikeTableClause.class)) {
            if (clause.getNode().getElementType() != methodKey) continue;
            refs.addAll(clause.getTableReferences());
        }
        ArrayList arrayList = refs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAncestors"));
        }
        return arrayList;
    }
}

