/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.database.util.Case;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresOptionalKeywords;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionBodyInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector", "getLanguagesToInject"));
        }
        if (!(context instanceof SqlStringLiteralExpression)) {
            return;
        }
        if (!SqlImplUtil.getSqlDialectSafe(context).getDatabaseDialect().getFamilyId().isPostgres()) {
            return;
        }
        Language language = FunctionBodyInjector.calcBodyLanguage(context.getNode(), context, registrar);
        if (language == null) {
            return;
        }
        SqlStringLiteralExpression host = (SqlStringLiteralExpression)context;
        registrar.startInjecting(language);
        registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, ElementManipulators.getValueTextRange((PsiElement)host));
        registrar.doneInjecting();
    }

    @Nullable
    public static Language calcBodyLanguage(@NotNull ASTNode node, @NotNull PsiElement context, @Nullable MultiHostRegistrar registrar) {
        Object lang;
        SqlStatement statement;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector", "calcBodyLanguage"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector", "calcBodyLanguage"));
        }
        ASTNode nodeParent = (ASTNode)ObjectUtils.assertNotNull((Object)node.getTreeParent());
        if (nodeParent.getElementType() == PostgresElementTypes.PG_LAZY_CODE_BLOCK) {
            node = nodeParent;
        }
        if (!((statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)context, SqlStatement.class, (boolean)false)) instanceof SqlCreateProcedureStatement || statement != null && statement.getFirstChild().getNode().getElementType() == PgTypes.PG_DO)) {
            return null;
        }
        ASTNode asNode = TreeUtil.findSiblingBackward((ASTNode)node, (IElementType)PostgresReservedKeywords.PG_AS);
        if (statement instanceof SqlCreateProcedureStatement && asNode == null) {
            return null;
        }
        ASTNode langNode = TreeUtil.findSibling((ASTNode)nodeParent.getFirstChildNode(), (IElementType)PostgresOptionalKeywords.PG_LANGUAGE);
        Object v0 = lang = langNode == null ? null : SqlImplUtil.getSiblingToTheRightOfType(langNode.getPsi(), true, PsiElement.class);
        if (lang != null && lang == context) {
            return null;
        }
        String text = lang == null ? null : lang.getText();
        return FunctionBodyInjector.getBlockByLangSpec(text, registrar);
    }

    @Nullable
    public static Language getBlockByLangSpec(@Nullable String text, @Nullable MultiHostRegistrar registrar) {
        String string = text = text == null ? null : Case.LOWER.apply(text);
        if (text == null) {
            return PostgresDialect.PlDialect.INSTANCE;
        }
        text = text.substring(text.startsWith("plpg") ? 4 : (text.startsWith("pl") ? 2 : 0), text.endsWith("u") ? text.length() - 1 : text.length());
        PostgresDialect.PlDialect language = null;
        String extension = text;
        if (text.contains("sql")) {
            language = PostgresDialect.PlDialect.INSTANCE;
        } else if (text.contains("python")) {
            language = Language.findLanguageByID((String)"Python");
            extension = "py";
        }
        if (language == null) {
            FileTypeManager typeManager = FileTypeManager.getInstance();
            FileType fileType = typeManager.getFileTypeByExtension(text);
            if (fileType == UnknownFileType.INSTANCE) {
                fileType = typeManager.getFileTypeByExtension(extension);
            }
            if (fileType instanceof LanguageFileType) {
                language = ((LanguageFileType)fileType).getLanguage();
                if (registrar instanceof MultiHostRegistrarImpl) {
                    ((MultiHostRegistrarImpl)registrar).setFileExtension(extension);
                }
            }
        }
        return (Language)ObjectUtils.chooseNotNull((Object)((Object)language), (Object)PlainTextLanguage.INSTANCE);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlStringLiteralExpressionImpl>> list = Collections.singletonList(SqlStringLiteralExpressionImpl.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

