/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.oracle.OraDdlParsing;
import com.intellij.sql.dialects.oracle.OraDmlParsing;
import com.intellij.sql.dialects.oracle.OraExpressionParsing;
import com.intellij.sql.dialects.oracle.OraGeneratedParser;
import com.intellij.sql.dialects.oracle.OraPlParsing;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;

public class OracleParser
extends SqlParser {
    public OracleParser() {
        super(OracleDialect.INSTANCE);
    }

    protected OracleParser(SqlLanguageDialectEx language) {
        super(language);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return OraGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return OraGeneratedParser.statement(builder, level);
    }

    @Override
    protected boolean allowIntervalLiteral() {
        return false;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return OraDmlParsing.query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return OraDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean parseStatementInsideJdbcCall(PsiBuilder builder, int level) {
        return OraPlParsing.statement_inside_jdbc_call(builder, level);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed) {
        this.parseJdbcProcedureCallBody(builder, level, refAlreadyParsed, SQL_OP_EQ, SQL_OP_ASSIGN);
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType paramToken, IElementType resultType) {
        PsiBuilder.Marker mark = builder.mark();
        this.consumeParameterReferenceInner(builder, paramToken);
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD)) {
            mark.done((IElementType)SQL_VARIABLE_REFERENCE);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_PERIOD);
            this.parseIdentifier(builder, false);
            mark.precede().done((IElementType)SQL_COLUMN_REFERENCE);
        } else {
            mark.done(resultType);
        }
        return true;
    }

    @Override
    public boolean isReservedKeywordHere(PsiBuilder builder, IElementType type) {
        SqlLanguageDialectEx language = this.getLanguage();
        return type instanceof SqlKeywordTokenType && SqlGeneratedParserUtil.isOn(builder, 0, "PL_DIALECT") ? language.isReservedKeywordPL(type) : language.isReservedKeyword(type);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result;
        boolean bl = result = !allowBoolean ? OraExpressionParsing.root_expr(builder, level, 2) : OraExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if (super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens)) {
            OracleParser.parseAnalyticAggregateFunctionTail(builder, level, definition);
            return true;
        }
        return false;
    }

    @Override
    protected boolean parsePrototypeTail(PsiBuilder builder, int level, SqlFunctionDefinition.Prototype parameter, SqlParser.FunctionParsingContext context) {
        if ("true".equals(parameter.getAttributes().get("aggregate"))) {
            OraGeneratedParser.aggregate_clause(builder, level);
        }
        if ("true".equals(parameter.getAttributes().get("analytic"))) {
            OraGeneratedParser.keep_clause(builder, level);
            OraGeneratedParser.analytic_clause(builder, level);
        }
        return super.parsePrototypeTail(builder, level, parameter, context);
    }

    @Override
    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        return this.parseNamedFunctionArgumentPrefixImpl(builder, (IElementType)SqlTokens.ORA_OP_NAMED_PARAM_BINDING);
    }

    @Override
    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return OraGeneratedParser.statement_recover_prefix(builder, level);
    }

    public static void parseAnalyticAggregateFunctionTail(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        if (definition == null) {
            return;
        }
        if ("true".equals(definition.getDialectAttribute("aggregate"))) {
            OraGeneratedParser.aggregate_clause(builder, level);
        }
        if ("true".equals(definition.getDialectAttribute("analytic"))) {
            OraGeneratedParser.keep_clause(builder, level);
            OraGeneratedParser.analytic_clause(builder, level);
        }
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        return OraExpressionParsing.opt_dblink_ref(builder, level);
    }

    public boolean convertToUseStatement(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame.elementType = SQL_USE_SCHEMA_STATEMENT;
        return true;
    }
}

