/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.psi.impl.SqlStatementImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MysqlShowStatementImpl
extends SqlStatementImpl {
    private static final Set<IElementType> DOUBLE_TYPES = ContainerUtil.newTroveSet((Object[])new IElementType[]{MysqlTypes.MYSQL_FUNCTION, MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_GLOBAL, MysqlTypes.MYSQL_SESSION, MysqlTypes.MYSQL_FULL});
    private static final Map<IElementType, IElementType> TYPE_MAPPING = ContainerUtil.immutableMapBuilder().put((Object)MysqlReservedKeywords.MYSQL_SCHEMAS, (Object)MysqlReservedKeywords.MYSQL_DATABASES).put((Object)MysqlTypes.MYSQL_INDEXES, (Object)MysqlReservedKeywords.MYSQL_INDEX).put((Object)MysqlReservedKeywords.MYSQL_KEYS, (Object)MysqlReservedKeywords.MYSQL_INDEX).build();
    private Pair<IElementType, IElementType> myShowType = null;

    public MysqlShowStatementImpl(ASTNode node) {
        super(node);
    }

    public void subtreeChanged() {
        this.myShowType = null;
        super.subtreeChanged();
    }

    @Nullable
    public Pair<IElementType, IElementType> getShowType() {
        IElementType second;
        if (this.myShowType != null) {
            return this.myShowType;
        }
        PsiElement leaf = MysqlShowStatementImpl.getNextLeaf(PsiTreeUtil.getDeepestFirst((PsiElement)this));
        IElementType first = MysqlShowStatementImpl.getType(leaf);
        if (first != null) {
            first = (IElementType)ContainerUtil.getOrElse(TYPE_MAPPING, (Object)first, (Object)first);
        }
        IElementType iElementType = second = DOUBLE_TYPES.contains(first) ? MysqlShowStatementImpl.getType(MysqlShowStatementImpl.getNextLeaf(leaf)) : null;
        if (second != null && first == MysqlTypes.MYSQL_GLOBAL || first == MysqlTypes.MYSQL_SESSION) {
            first = second;
            second = null;
        }
        this.myShowType = Pair.create((Object)first, (Object)second);
        return this.myShowType;
    }

    @Nullable
    private static IElementType getType(@Nullable PsiElement leaf) {
        ASTNode node = leaf == null ? null : leaf.getNode();
        return node == null ? null : node.getElementType();
    }

    @Nullable
    private static PsiElement getNextLeaf(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return null;
        }
        while ((leaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf)) instanceof PsiComment) {
        }
        return leaf;
    }
}

