/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectsConfigurable
extends LanguagePerFileConfigurable<SqlLanguageDialect> {
    public SqlDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlDialectsConfigurable", "<init>"));
        }
        super(project, SqlLanguageDialect.class, (PerFileMappings)SqlDialectMappings.getInstance(project), SqlMessages.message("dialog.sql.dialects.caption", ApplicationNamesInfo.getInstance().getProductName(), StringUtil.escapeXml((String)DbSqlUtil.getGenericDialect().getDisplayName())), SqlMessages.message("dialog.sql.dialects.value.title", new Object[0]), SqlMessages.message("dialog.sql.dialects.override.question", new Object[0]), SqlMessages.message("dialog.sql.dialects.override.title", new Object[0]));
    }

    @Nls
    public String getDisplayName() {
        return SqlMessages.message("sql.dialects.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.dialects";
    }

    protected String visualize(@NotNull SqlLanguageDialect sqlLanguageDialect) {
        if (sqlLanguageDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlLanguageDialect", "com/intellij/sql/dialects/SqlDialectsConfigurable", "visualize"));
        }
        return sqlLanguageDialect.getDisplayName();
    }

    protected boolean handleDefaultValue(VirtualFile file, ColoredTableCellRenderer renderer) {
        SqlLanguageDialect t = (SqlLanguageDialect)this.getNewMapping(file);
        if (t != null) {
            renderer.append(this.visualize(t), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        return t != null;
    }

    public static void openDialectsConfigurable(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlDialectsConfigurable", "openDialectsConfigurable"));
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }
}

