/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.database.model.DasColumn;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVariableDefinition;
import org.jetbrains.annotations.NotNull;

public class SqlReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlReadWriteAccessDetector", "isReadWriteAccessible"));
        }
        return element instanceof SqlDefinition;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlReadWriteAccessDetector", "isDeclarationWriteAccess"));
        }
        return element instanceof SqlVariableDefinition && ((SqlVariableDefinition)element).getInitializer() != null;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedElement", "com/intellij/sql/SqlReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/sql/SqlReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (!(referencedElement instanceof DasColumn) && !(referencedElement instanceof SqlAsExpression)) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getReferenceAccess"));
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getReferenceAccess"));
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlReadWriteAccessDetector", "getExpressionAccess"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof SqlBinaryExpression) {
            SqlBinaryExpression binaryExpression = (SqlBinaryExpression)parent;
            ReadWriteAccessDetector.Access access = binaryExpression.getOpSign() == SqlTokens.SQL_OP_ASSIGN && binaryExpression.getLOperand() == expression ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        SqlTableColumnsList tableColumnList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlTableColumnsList.class);
        if (tableColumnList != null) {
            ReadWriteAccessDetector.Access access = tableColumnList.getParent() instanceof SqlDmlInstruction && tableColumnList.getParent().getParent() instanceof SqlInsertStatement ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        SqlSetClause setClause = (SqlSetClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSetClause.class);
        if (setClause != null) {
            PsiElement first = parent instanceof SqlReferenceList ? parent : expression;
            for (PsiElement child = first.getNextSibling(); child != null; child = child.getNextSibling()) {
                IElementType elementType = child.getNode().getElementType();
                if (elementType == SqlTokens.SQL_COMMA) {
                    ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
                    if (access == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getExpressionAccess"));
                    }
                    return access;
                }
                if (elementType != SqlTokens.SQL_OP_EQ) continue;
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getExpressionAccess"));
                }
                return access;
            }
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlReadWriteAccessDetector", "getExpressionAccess"));
        }
        return access;
    }
}

