/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.DatabasePluginId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SqlFileTypeFactoryBase
extends FileTypeFactory {
    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/sql/SqlFileTypeFactoryBase", "createFileTypes"));
        }
        consumer.consume((FileType)SqlFileType.INSTANCE, "sql;ddl");
        SqlFileTypeFactoryBase.initSqlDialects();
    }

    private static void initSqlDialects() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)DatabasePluginId.get());
        LanguageExtensionPoint[] extensions = (LanguageExtensionPoint[])Extensions.getExtensions((ExtensionPointName)new ExtensionPointName("com.intellij.lang.parserDefinition"));
        HashSet<String> dialectIds = new HashSet<String>();
        SqlCommonKeywords.class.getName();
        for (LanguageExtensionPoint parserDefinition : extensions) {
            if (parserDefinition.getPluginDescriptor() != plugin || parserDefinition.implementationClass == null || !StringUtil.startsWith((CharSequence)parserDefinition.implementationClass, (CharSequence)"com.intellij.sql")) continue;
            try {
                parserDefinition.getInstance();
                dialectIds.add(parserDefinition.language);
            }
            catch (Exception e) {
                SqlDialectImplUtil.LOG.error((Throwable)e);
            }
        }
        if (!dialectIds.containsAll(Arrays.asList("MySQL", "Oracle", "PostgreSQL", "SQLite", "GenericSQL"))) {
            SqlDialectImplUtil.LOG.error("Required SQL dialects not found among: " + dialectIds);
        }
    }
}

