/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import org.jetbrains.annotations.NotNull;

public class SqlCopyPasteProcessor
implements CopyPastePreProcessor {
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        Object elementType = SqlTokens.SQL_STRING_TOKEN;
        for (int i2 = 0; i2 < startOffsets.length && elementType != null; ++i2) {
            int startOffset = startOffsets[i2];
            PsiElement elementAtCaret = file.findElementAt(startOffset);
            elementType = !(elementAtCaret instanceof SqlStringTokenElement) || startOffset < elementAtCaret.getTextRange().getStartOffset() || endOffsets[i2] > elementAtCaret.getTextRange().getEndOffset() ? null : ((SqlStringTokenElement)elementAtCaret).getElementType();
        }
        return elementType == null ? null : SqlStringLiteralManipulator.unescapeSqlStringCharacters(text, (IElementType)elementType);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = file.findElementAt(caretOffset);
        if (elementAtCaret instanceof SqlStringTokenElement && caretOffset > elementAtCaret.getTextOffset()) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlCopyPasteProcessor", "preprocessOnPaste"));
                }
                return string;
            }
            text = SqlStringLiteralManipulator.escapeSqlStringCharacters(text, ((SqlStringTokenElement)elementAtCaret).getElementType());
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlCopyPasteProcessor", "preprocessOnPaste"));
        }
        return string;
    }
}

