/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Strings;

public abstract class QueryRewriters {
    public static StringOperator substitute(final @NotNull String what, final @NotNull String with) {
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/common/QueryRewriters", "substitute"));
        }
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/intellij/dbm/common/QueryRewriters", "substitute"));
        }
        return new StringOperator(){

            public String apply(String arg) {
                return Strings.replace((String)arg, (String)what, (String)with);
            }
        };
    }

    public static StringOperator substitute(final @NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/dbm/common/QueryRewriters", "substitute"));
        }
        return new StringOperator(){

            public String apply(String arg) {
                if (map.isEmpty()) {
                    return arg;
                }
                if (arg == null) {
                    return null;
                }
                boolean was = false;
                StringBuilder b = new StringBuilder(arg);
                for (Map.Entry entry : map.entrySet()) {
                    String what = (String)entry.getKey();
                    String with = (String)entry.getValue();
                    int p = b.indexOf(what);
                    while (p >= 0) {
                        b.replace(p, p + what.length(), with);
                        p = b.indexOf(what, p + with.length());
                        was = true;
                    }
                }
                return was ? b.toString() : arg;
            }
        };
    }
}

