/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataSourceSettings {
    private final DbPsiFacade myPsiFacade;
    private final List<DbDataSource> myNewDataSources;
    private final List<DatabaseDriver> myNewDrivers;
    private DbDataSource myCurrentDataSource;

    public DataSourceSettings(@NotNull DbPsiFacade psiFacade, @Nullable DbDataSource currentDataSource) {
        if (psiFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFacade", "com/intellij/database/view/ui/DataSourceSettings", "<init>"));
        }
        this.myNewDataSources = ContainerUtil.newArrayList();
        this.myNewDrivers = ContainerUtil.newArrayList();
        this.myPsiFacade = psiFacade;
        this.myCurrentDataSource = currentDataSource;
    }

    @NotNull
    public DbPsiFacade getPsiFacade() {
        DbPsiFacade dbPsiFacade = this.myPsiFacade;
        if (dbPsiFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceSettings", "getPsiFacade"));
        }
        return dbPsiFacade;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPsiFacade.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceSettings", "getProject"));
        }
        return project;
    }

    @NotNull
    public List<DbDataSource> getDataSources() {
        List list = this.myPsiFacade.getDataSources();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceSettings", "getDataSources"));
        }
        return list;
    }

    @Nullable
    public DbDataSource getCurrentDataSource() {
        return this.myCurrentDataSource;
    }

    public void setCurrentDataSource(DbDataSource currentDataSource) {
        this.myCurrentDataSource = currentDataSource;
    }

    @NotNull
    public List<DbDataSource> getNewDataSources() {
        List<DbDataSource> list = this.myNewDataSources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceSettings", "getNewDataSources"));
        }
        return list;
    }

    public void addNewDataSource(@NotNull DbDataSource element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/ui/DataSourceSettings", "addNewDataSource"));
        }
        this.myNewDataSources.add(element);
    }

    public void removeNewDataSource(DbDataSource element) {
        this.myNewDataSources.remove(element);
    }

    public List<DatabaseDriver> getNewDrivers() {
        return this.myNewDrivers;
    }

    public void addNewDriver(DatabaseDriver driver) {
        this.myNewDrivers.add(driver);
    }

    public void removeNewDriver(DatabaseDriver driver) {
        this.myNewDrivers.remove(driver);
    }
}

