/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models.builder;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.build.DeBuilderBase;
import com.intellij.database.schemaEditor.model.build.DeTableBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.ForeignKeyEditorModel;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.database.view.models.builder.ColumnModelBuilder;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.JBIterable;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableModelBuilder<Self extends TableModelBuilder<?>>
extends DeBuilderBase<Self>
implements DeTableBuilder<Self> {
    protected final TableEditorModel myTableModel;

    public static TableModelBuilder<?> modify(@NotNull TableEditorModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/view/models/builder/TableModelBuilder", "modify"));
        }
        return new TableModelBuilderImpl(tableModel);
    }

    public static TableModelBuilder<?> modify(@NotNull DeTable table, @NotNull EditorModelsCache cache) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/models/builder/TableModelBuilder", "modify"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/view/models/builder/TableModelBuilder", "modify"));
        }
        return new TableModelBuilderImpl(cache.get(table, TableEditorModel.class));
    }

    protected TableModelBuilder(TableEditorModel tableModel) {
        this.myTableModel = tableModel;
    }

    public TableColumnModelBuilder<?> withColumn(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/builder/TableModelBuilder", "withColumn"));
        }
        return this.modifyColumn(new DeColumn(name, (DeTable)this.myTableModel.getObject(), ((DeTable)this.myTableModel.getObject()).model));
    }

    public TableColumnModelBuilder<?> modifyColumn(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyColumn"));
        }
        DeColumn first = (DeColumn)JBIterable.from(((DeTable)this.myTableModel.getObject()).columns).filter(DasUtil.byName((String)name, (CasingProvider)this.myTableModel.getModel())).first();
        if (first == null) {
            throw new NoSuchElementException(name);
        }
        return this.modifyColumn(first);
    }

    public TableColumnModelBuilder<?> modifyColumn(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyColumn"));
        }
        return this.modifyColumn(this.myTableModel.modelsCache.get(column, ColumnEditorModel.class));
    }

    public TableColumnModelBuilder<?> modifyColumn(@NotNull ColumnEditorModel columnModel) {
        if (columnModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyColumn"));
        }
        return new TableColumnModelBuilderImpl(columnModel);
    }

    public TableKeyModelBuilder<?> withKey(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/builder/TableModelBuilder", "withKey"));
        }
        return this.modifyKey(new DeTableKey(name, (DeTable)this.myTableModel.getObject(), ((DeTable)this.myTableModel.getObject()).model));
    }

    public TableKeyModelBuilder<?> modifyKey(@NotNull DeTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyKey"));
        }
        return this.modifyKey(this.myTableModel.modelsCache.get(key, TableKeyEditorModel.class));
    }

    public TableKeyModelBuilder<?> modifyKey(@NotNull TableKeyEditorModel keyModel) {
        if (keyModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyModel", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyKey"));
        }
        return new TableKeyModelBuilderImpl(keyModel);
    }

    public TableIndexModelBuilder<?> withIndex(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/builder/TableModelBuilder", "withIndex"));
        }
        return this.modifyIndex(new DeIndex(name, (DeTable)this.myTableModel.getObject(), ((DeTable)this.myTableModel.getObject()).model));
    }

    public TableIndexModelBuilder<?> modifyIndex(@NotNull DeIndex index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyIndex"));
        }
        return this.modifyIndex(this.myTableModel.modelsCache.get(index, IndexEditorModel.class));
    }

    public TableIndexModelBuilder<?> modifyIndex(@NotNull IndexEditorModel indexModel) {
        if (indexModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexModel", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyIndex"));
        }
        return new TableIndexModelBuilderImpl(indexModel);
    }

    public TableForeignKeyModelBuilder<?> withForeignKey(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/builder/TableModelBuilder", "withForeignKey"));
        }
        return this.modifyForeignKey(new DeForeignKey(name, (DeTable)this.myTableModel.getObject(), ((DeTable)this.myTableModel.getObject()).model));
    }

    public TableForeignKeyModelBuilder<?> modifyForeignKey(@NotNull DeForeignKey foreignKey) {
        if (foreignKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKey", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyForeignKey"));
        }
        return this.modifyForeignKey(this.myTableModel.modelsCache.get(foreignKey, ForeignKeyEditorModel.class));
    }

    public TableForeignKeyModelBuilder<?> modifyForeignKey(@NotNull ForeignKeyEditorModel foreignKeyModel) {
        if (foreignKeyModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeyModel", "com/intellij/database/view/models/builder/TableModelBuilder", "modifyForeignKey"));
        }
        return new TableForeignKeyModelBuilderImpl(foreignKeyModel);
    }

    public void commit() {
        this.myTableModel.commit();
    }

    public static class TableModelBuilderImpl
    extends TableModelBuilder<TableModelBuilderImpl> {
        protected TableModelBuilderImpl(TableEditorModel tableModel) {
            super(tableModel);
        }
    }

    public class TableForeignKeyModelBuilderImpl
    extends TableForeignKeyModelBuilder<TableForeignKeyModelBuilderImpl> {
        protected TableForeignKeyModelBuilderImpl(ForeignKeyEditorModel foreignKeyModel) {
            if (foreignKeyModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeyModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableForeignKeyModelBuilderImpl", "<init>"));
            }
            super(foreignKeyModel);
        }
    }

    public class TableIndexModelBuilderImpl
    extends TableIndexModelBuilder<TableIndexModelBuilderImpl> {
        protected TableIndexModelBuilderImpl(IndexEditorModel indexModel) {
            if (indexModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableIndexModelBuilderImpl", "<init>"));
            }
            super(indexModel);
        }
    }

    public class TableKeyModelBuilderImpl
    extends TableKeyModelBuilder<TableKeyModelBuilderImpl> {
        protected TableKeyModelBuilderImpl(TableKeyEditorModel keyModel) {
            if (keyModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableKeyModelBuilderImpl", "<init>"));
            }
            super(keyModel);
        }
    }

    public class TableColumnModelBuilderImpl
    extends TableColumnModelBuilder<TableColumnModelBuilderImpl> {
        protected TableColumnModelBuilderImpl(ColumnEditorModel columnModel) {
            if (columnModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableColumnModelBuilderImpl", "<init>"));
            }
            super(columnModel);
        }
    }

    public class TableForeignKeyModelBuilder<CB extends TableForeignKeyModelBuilder<?>>
    extends ForeignKeyModelBuilder<CB>
    implements DeTableBuilder.DeTableForeignKeyBuilder<Self, CB> {
        protected TableForeignKeyModelBuilder(ForeignKeyEditorModel foreignKeyModel) {
            if (foreignKeyModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeyModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableForeignKeyModelBuilder", "<init>"));
            }
            super(foreignKeyModel);
        }

        @Override
        public CB add() {
            return this.addAndGet(null);
        }

        public CB addAndGet(@Nullable Ref<DeForeignKey> columnRef) {
            this.commit();
            TableModelBuilder.this.myTableModel.addForeignKey((DeForeignKey)this.myForeignKeyModel.getObject());
            if (columnRef != null) {
                columnRef.set(this.myForeignKeyModel.getObject());
            }
            return (CB)((TableForeignKeyModelBuilder)this.self());
        }

        @Override
        public Self leave() {
            return (TableModelBuilder)TableModelBuilder.this.self();
        }
    }

    public class TableIndexModelBuilder<CB extends TableIndexModelBuilder<?>>
    extends IndexModelBuilder<CB>
    implements DeTableBuilder.DeTableIndexBuilder<Self, CB> {
        protected TableIndexModelBuilder(IndexEditorModel indexModel) {
            if (indexModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableIndexModelBuilder", "<init>"));
            }
            super(indexModel);
        }

        @Override
        public CB add() {
            return this.addAndGet(null);
        }

        public CB addAndGet(@Nullable Ref<DeIndex> columnRef) {
            this.commit();
            TableModelBuilder.this.myTableModel.addIndex((DeIndex)this.myIndexModel.getObject());
            if (columnRef != null) {
                columnRef.set(this.myIndexModel.getObject());
            }
            return (CB)((TableIndexModelBuilder)this.self());
        }

        @Override
        public Self leave() {
            return (TableModelBuilder)TableModelBuilder.this.self();
        }
    }

    public class TableKeyModelBuilder<CB extends TableKeyModelBuilder<?>>
    extends KeyModelBuilder<CB>
    implements DeTableBuilder.DeTableKeyBuilder<Self, CB> {
        protected TableKeyModelBuilder(TableKeyEditorModel keyModel) {
            if (keyModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableKeyModelBuilder", "<init>"));
            }
            super(keyModel);
        }

        @Override
        public CB add() {
            return this.addAndGet(null);
        }

        public CB addAndGet(@Nullable Ref<DeTableKey> columnRef) {
            this.commit();
            TableModelBuilder.this.myTableModel.addTableKey((DeTableKey)this.myKeyModel.getObject());
            if (columnRef != null) {
                columnRef.set(this.myKeyModel.getObject());
            }
            return (CB)((TableKeyModelBuilder)this.self());
        }

        @Override
        public Self leave() {
            return (TableModelBuilder)TableModelBuilder.this.self();
        }

        @Override
        public CB setPrimary(boolean primary, boolean removePrev) {
            DeTableKey prev = TableModelBuilder.this.myTableModel.getPrimaryKey();
            TableModelBuilder.this.myTableModel.setPrimaryKey(primary ? (DeTableKey)this.myKeyModel.getObject() : null);
            if (prev != null && prev != this.myKeyModel.getObject() && removePrev) {
                TableModelBuilder.this.myTableModel.removeTableKey(prev);
            }
            return (CB)((TableKeyModelBuilder)this.self());
        }
    }

    public class TableColumnModelBuilder<CB extends TableColumnModelBuilder<?>>
    extends ColumnModelBuilder<CB>
    implements DeTableBuilder.DeTableColumnBuilder<Self, CB> {
        protected TableColumnModelBuilder(ColumnEditorModel columnModel) {
            if (columnModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/view/models/builder/TableModelBuilder$TableColumnModelBuilder", "<init>"));
            }
            super(columnModel);
        }

        @Override
        public CB add() {
            return this.addAndGet(null);
        }

        public CB addAndGet(@Nullable Ref<DeColumn> columnRef) {
            this.commit();
            TableModelBuilder.this.myTableModel.insertColumn((DeColumn)this.myColumnModel.getObject(), TableModelBuilder.this.myTableModel.getColumnsCount());
            if (columnRef != null) {
                columnRef.set(this.myColumnModel.getObject());
            }
            return (CB)((TableColumnModelBuilder)this.self());
        }

        @Override
        public Self leave() {
            return (TableModelBuilder)TableModelBuilder.this.self();
        }
    }
}

